from typing import List
from dataclasses import dataclass, field
from crm.supskills.common.direct_client.structs.enums.general import YesNoEnum
from crm.supskills.common.direct_client.structs.enums.bidmodifiers import BidModifierLevelEnum, BidModifierTypeEnum, \
    OperatingSystemTypeEnum, GenderEnum, AgeRangeEnum


@dataclass
class MobileAdjustmentGet:
    BidModifier: int = field(default=None)
    OperatingSystemType: OperatingSystemTypeEnum = field(default=None)


@dataclass
class DesktopAdjustmentGet:
    BidModifier: int = field(default=None)


@dataclass
class DemographicsAdjustmentGet:
    Gender: GenderEnum = field(default=None)
    Age: AgeRangeEnum = field(default=None)
    BidModifier: int = field(default=None)
    Enabled: YesNoEnum = field(default=None)


@dataclass
class RetargetingAdjustmentGet:
    RetargetingConditionId: int = field(default=None)
    Accessible: YesNoEnum = field(default=None)
    BidModifier: int = field(default=None)
    Enabled: YesNoEnum = field(default=None)


@dataclass
class RegionalAdjustmentGet:
    RegionId: int = field(default=None)
    BidModifier: int = field(default=None)
    Enabled: YesNoEnum = field(default=None)


@dataclass
class VideoAdjustmentGet:
    BidModifier: int = field(default=None)


@dataclass
class SmartAdAdjustmentGet:
    BidModifier: int = field(default=None)


@dataclass
class BidModifierGetItem:
    Id: int = field(default=None)
    AdGroupId: int = field(default=None)
    CampaignId: int = field(default=None)
    Level: BidModifierLevelEnum = field(default=None)
    Type: BidModifierTypeEnum = field(default=None)
    MobileAdjustment: MobileAdjustmentGet = field(default=None)
    DesktopAdjustment: DesktopAdjustmentGet = field(default=None)
    VideoAdjustment: VideoAdjustmentGet = field(default=None)
    DemographicsAdjustment: DemographicsAdjustmentGet = field(default=None)
    RetargetingAdjustment: RetargetingAdjustmentGet = field(default=None)
    RegionalAdjustment: RegionalAdjustmentGet = field(default=None)
    SmartAdAdjustment: SmartAdAdjustmentGet = field(default=None)


@dataclass
class result:
    BidModifiers: List[BidModifierGetItem] = field(default=None)
    LimitedBy: int = field(default=None)
