from typing import Any, List
from dataclasses import dataclass, field
from crm.supskills.common.direct_client.structs.structs.general import StatisticsClass, ArrayOfString, ArrayOfIntegers
from crm.supskills.common.direct_client.structs.enums.general import YesNoEnum, StatusEnum, CurrencyEnum
from crm.supskills.common.direct_client.structs.enums.campaigns import DailyBudgetModeEnum, SmsEventsEnum, \
    CampaignFundsEnum, CampaignTypeGetEnum, AttributionModelEnum, SmartCampaignNetworkStrategyTypeEnum, \
    CampaignStateGetEnum, CpmBannerCampaignSettingsGetEnum, TextCampaignNetworkStrategyTypeEnum, \
    MobileAppCampaignSearchStrategyTypeEnum, MobileAppCampaignSettingsEnum, DynamicTextCampaignSearchStrategyTypeEnum, \
    DynamicTextCampaignNetworkStrategyTypeEnum, DynamicTextCampaignSettingsGetEnum, TextCampaignSettingsEnum, \
    CpmBannerCampaignNetworkStrategyTypeEnum, CpmBannerCampaignSearchStrategyTypeEnum, CampaignStatusPaymentEnum, \
    SmartCampaignSearchStrategyTypeEnum, SmartCampaignSettingsGetEnum, TextCampaignSearchStrategyTypeEnum, \
    MobileAppCampaignNetworkStrategyTypeEnum

StrategyAverageRoi = Any
StrategyAverageCrr = Any
StrategyPayForConversionCrr = Any
StrategyPayForConversion = Any
StrategyWeeklyClickPackage = Any
StrategyNetworkDefault = Any
StrategyMaximumAppInstalls = Any
StrategyAverageCpi = Any
StrategyPayForInstall = Any
StrategyWbMaximumImpressions = Any
StrategyCpMaximumImpressions = Any
StrategyWbDecreasedPriceForRepeatedImpressions = Any
StrategyCpDecreasedPriceForRepeatedImpressions = Any
StrategyWbAverageCpv = Any
StrategyCpAverageCpv = Any
StrategyAverageCpaPerCampaign = Any
StrategyAverageCpaPerFilter = Any
StrategyAverageCpcPerCampaign = Any
StrategyAverageCpcPerFilter = Any
StrategyPayForConversionPerCampaign = Any
StrategyPayForConversionPerFilter = Any


@dataclass
class DailyBudgetClass:
    Amount: int = field(default=None)
    Mode: DailyBudgetModeEnum = field(default=None)


@dataclass
class SmsSettingsClass:
    Events: List[SmsEventsEnum] = field(default=None)
    TimeFrom: str = field(default=None)
    TimeTo: str = field(default=None)


@dataclass
class EmailSettingsClass:
    Email: str = field(default=None)
    CheckPositionInterval: int = field(default=None)
    WarningBalance: int = field(default=None)
    SendAccountNews: YesNoEnum = field(default=None)
    SendWarnings: YesNoEnum = field(default=None)


@dataclass
class NotificationClass:
    SmsSettings: SmsSettingsClass = field(default=None)
    EmailSettings: EmailSettingsClass = field(default=None)


@dataclass
class CampaignFundsParam:
    Sum: int = field(default=None)
    Balance: int = field(default=None)
    BalanceBonus: int = field(default=None)
    SumAvailableForTransfer: int = field(default=None)


@dataclass
class SharedAccountFundsParam:
    Refund: int = field(default=None)
    Spend: int = field(default=None)


@dataclass
class FundsParam:
    Mode: CampaignFundsEnum = field(default=None)
    CampaignFunds: CampaignFundsParam = field(default=None)
    SharedAccountFunds: SharedAccountFundsParam = field(default=None)


@dataclass
class CampaignAssistant:
    Manager: str = field(default=None)
    Agency: str = field(default=None)


@dataclass
class PriorityGoalsItem:
    GoalId: int = field(default=None)
    Value: int = field(default=None)


@dataclass
class PriorityGoalsArray:
    Items: List[PriorityGoalsItem] = field(default=None)


@dataclass
class TextCampaignSettingGet:
    Option: TextCampaignSettingsEnum = field(default=None)
    Value: YesNoEnum = field(default=None)


@dataclass
class RelevantKeywordsSetting:
    BudgetPercent: int = field(default=None)
    OptimizeGoalId: int = field(default=None)


@dataclass
class StrategyMaximumClicks:
    WeeklySpendLimit: int = field(default=None)
    BidCeiling: int = field(default=None)


@dataclass
class StrategyMaximumConversionRate:
    WeeklySpendLimit: int = field(default=None)
    BidCeiling: int = field(default=None)
    GoalId: int = field(default=None)


@dataclass
class StrategyAverageCpc:
    AverageCpc: int = field(default=None)
    WeeklySpendLimit: int = field(default=None)


@dataclass
class StrategyAverageCpa:
    AverageCpa: int = field(default=None)
    GoalId: int = field(default=None)
    WeeklySpendLimit: int = field(default=None)
    BidCeiling: int = field(default=None)


@dataclass
class TextCampaignSearchStrategy:
    BiddingStrategyType: TextCampaignSearchStrategyTypeEnum = field(default=None)
    WbMaximumClicks: StrategyMaximumClicks = field(default=None)
    WbMaximumConversionRate: StrategyMaximumConversionRate = field(default=None)
    AverageCpc: StrategyAverageCpc = field(default=None)
    AverageCpa: StrategyAverageCpa = field(default=None)
    AverageRoi: StrategyAverageRoi = field(default=None)
    AverageCrr: StrategyAverageCrr = field(default=None)
    PayForConversionCrr: StrategyPayForConversionCrr = field(default=None)
    PayForConversion: StrategyPayForConversion = field(default=None)
    WeeklyClickPackage: StrategyWeeklyClickPackage = field(default=None)


@dataclass
class TextCampaignNetworkStrategy:
    BiddingStrategyType: TextCampaignNetworkStrategyTypeEnum = field(default=None)
    NetworkDefault: StrategyNetworkDefault = field(default=None)
    WbMaximumClicks: StrategyMaximumClicks = field(default=None)
    WbMaximumConversionRate: StrategyMaximumConversionRate = field(default=None)
    AverageCpc: StrategyAverageCpc = field(default=None)
    AverageCpa: StrategyAverageCpa = field(default=None)
    AverageRoi: StrategyAverageRoi = field(default=None)
    AverageCrr: StrategyAverageCrr = field(default=None)
    PayForConversionCrr: StrategyPayForConversionCrr = field(default=None)
    PayForConversion: StrategyPayForConversion = field(default=None)
    WeeklyClickPackage: StrategyWeeklyClickPackage = field(default=None)


@dataclass
class TextCampaignStrategy:
    Search: TextCampaignSearchStrategy = field(default=None)
    Network: TextCampaignNetworkStrategy = field(default=None)


@dataclass
class TextCampaignGetItem:
    Settings: List[TextCampaignSettingGet] = field(default=None)
    CounterIds: ArrayOfIntegers = field(default=None)
    RelevantKeywords: RelevantKeywordsSetting = field(default=None)
    BiddingStrategy: TextCampaignStrategy = field(default=None)
    PriorityGoals: PriorityGoalsArray = field(default=None)
    AttributionModel: AttributionModelEnum = field(default=None)


@dataclass
class TimeTargetingOnPublicHolidays:
    SuspendOnHolidays: YesNoEnum = field(default=None)
    BidPercent: int = field(default=None)
    StartHour: int = field(default=None)
    EndHour: int = field(default=None)


@dataclass
class TimeTargetingClass:
    Schedule: ArrayOfString = field(default=None)
    ConsiderWorkingWeekends: YesNoEnum = field(default=None)
    HolidaysSchedule: TimeTargetingOnPublicHolidays = field(default=None)


@dataclass
class MobileAppCampaignNetworkStrategy:
    BiddingStrategyType: MobileAppCampaignNetworkStrategyTypeEnum = field(default=None)
    NetworkDefault: StrategyNetworkDefault = field(default=None)
    WbMaximumClicks: StrategyMaximumClicks = field(default=None)
    WbMaximumAppInstalls: StrategyMaximumAppInstalls = field(default=None)
    AverageCpc: StrategyAverageCpc = field(default=None)
    AverageCpi: StrategyAverageCpi = field(default=None)
    PayForInstall: StrategyPayForInstall = field(default=None)
    WeeklyClickPackage: StrategyWeeklyClickPackage = field(default=None)


@dataclass
class MobileAppCampaignSearchStrategy:
    BiddingStrategyType: MobileAppCampaignSearchStrategyTypeEnum = field(default=None)
    WbMaximumClicks: StrategyMaximumClicks = field(default=None)
    WbMaximumAppInstalls: StrategyMaximumAppInstalls = field(default=None)
    AverageCpc: StrategyAverageCpc = field(default=None)
    AverageCpi: StrategyAverageCpi = field(default=None)
    PayForInstall: StrategyPayForInstall = field(default=None)
    WeeklyClickPackage: StrategyWeeklyClickPackage = field(default=None)


@dataclass
class MobileAppCampaignStrategy:
    Search: MobileAppCampaignSearchStrategy = field(default=None)
    Network: MobileAppCampaignNetworkStrategy = field(default=None)


@dataclass
class MobileAppCampaignSettingGet:
    Option: MobileAppCampaignSettingsEnum = field(default=None)
    Value: YesNoEnum = field(default=None)


@dataclass
class MobileAppCampaignGetItem:
    Settings: List[MobileAppCampaignSettingGet] = field(default=None)
    BiddingStrategy: MobileAppCampaignStrategy = field(default=None)


@dataclass
class DynamicTextCampaignSearchStrategy:
    BiddingStrategyType: DynamicTextCampaignSearchStrategyTypeEnum = field(default=None)
    WbMaximumClicks: StrategyMaximumClicks = field(default=None)
    WbMaximumConversionRate: StrategyMaximumConversionRate = field(default=None)
    AverageCpc: StrategyAverageCpc = field(default=None)
    AverageCpa: StrategyAverageCpa = field(default=None)
    AverageRoi: StrategyAverageRoi = field(default=None)
    AverageCrr: StrategyAverageCrr = field(default=None)
    PayForConversionCrr: StrategyPayForConversionCrr = field(default=None)
    PayForConversion: StrategyPayForConversion = field(default=None)
    WeeklyClickPackage: StrategyWeeklyClickPackage = field(default=None)


@dataclass
class DynamicTextCampaignNetworkStrategy:
    BiddingStrategyType: DynamicTextCampaignNetworkStrategyTypeEnum = field(default=None)


@dataclass
class DynamicTextCampaignStrategy:
    Search: DynamicTextCampaignSearchStrategy = field(default=None)
    Network: DynamicTextCampaignNetworkStrategy = field(default=None)


@dataclass
class DynamicTextCampaignSettingGet:
    Option: DynamicTextCampaignSettingsGetEnum = field(default=None)
    Value: YesNoEnum = field(default=None)


@dataclass
class DynamicTextCampaignGetItem:
    CounterIds: ArrayOfIntegers = field(default=None)
    BiddingStrategy: DynamicTextCampaignStrategy = field(default=None)
    Settings: List[DynamicTextCampaignSettingGet] = field(default=None)
    PriorityGoals: PriorityGoalsArray = field(default=None)
    AttributionModel: AttributionModelEnum = field(default=None)


@dataclass
class CpmBannerCampaignSearchStrategy:
    BiddingStrategyType: CpmBannerCampaignSearchStrategyTypeEnum = field(default=None)


@dataclass
class CpmBannerCampaignNetworkStrategy:
    BiddingStrategyType: CpmBannerCampaignNetworkStrategyTypeEnum = field(default=None)
    WbMaximumImpressions: StrategyWbMaximumImpressions = field(default=None)
    CpMaximumImpressions: StrategyCpMaximumImpressions = field(default=None)
    WbDecreasedPriceForRepeatedImpressions: StrategyWbDecreasedPriceForRepeatedImpressions = field(default=None)
    CpDecreasedPriceForRepeatedImpressions: StrategyCpDecreasedPriceForRepeatedImpressions = field(default=None)
    WbAverageCpv: StrategyWbAverageCpv = field(default=None)
    CpAverageCpv: StrategyCpAverageCpv = field(default=None)


@dataclass
class CpmBannerCampaignStrategy:
    Search: CpmBannerCampaignSearchStrategy = field(default=None)
    Network: CpmBannerCampaignNetworkStrategy = field(default=None)


@dataclass
class CpmBannerCampaignSettingGet:
    Option: CpmBannerCampaignSettingsGetEnum = field(default=None)
    Value: YesNoEnum = field(default=None)


@dataclass
class FrequencyCapSetting:
    Impressions: int = field(default=None)
    PeriodDays: int = field(default=None)


@dataclass
class CpmBannerCampaignGetItem:
    BiddingStrategy: CpmBannerCampaignStrategy = field(default=None)
    Settings: List[CpmBannerCampaignSettingGet] = field(default=None)
    CounterIds: ArrayOfIntegers = field(default=None)
    FrequencyCap: FrequencyCapSetting = field(default=None)


@dataclass
class SmartCampaignSearchStrategy:
    BiddingStrategyType: SmartCampaignSearchStrategyTypeEnum = field(default=None)
    AverageCpaPerCampaign: StrategyAverageCpaPerCampaign = field(default=None)
    AverageCpaPerFilter: StrategyAverageCpaPerFilter = field(default=None)
    AverageCpcPerCampaign: StrategyAverageCpcPerCampaign = field(default=None)
    AverageCpcPerFilter: StrategyAverageCpcPerFilter = field(default=None)
    AverageRoi: StrategyAverageRoi = field(default=None)
    AverageCrr: StrategyAverageCrr = field(default=None)
    PayForConversionCrr: StrategyPayForConversionCrr = field(default=None)
    PayForConversionPerCampaign: StrategyPayForConversionPerCampaign = field(default=None)
    PayForConversionPerFilter: StrategyPayForConversionPerFilter = field(default=None)


@dataclass
class SmartCampaignNetworkStrategy:
    BiddingStrategyType: SmartCampaignNetworkStrategyTypeEnum = field(default=None)
    AverageCpaPerCampaign: StrategyAverageCpaPerCampaign = field(default=None)
    AverageCpaPerFilter: StrategyAverageCpaPerFilter = field(default=None)
    AverageCpcPerCampaign: StrategyAverageCpcPerCampaign = field(default=None)
    AverageCpcPerFilter: StrategyAverageCpcPerFilter = field(default=None)
    AverageRoi: StrategyAverageRoi = field(default=None)
    AverageCrr: StrategyAverageCrr = field(default=None)
    PayForConversionCrr: StrategyPayForConversionCrr = field(default=None)
    PayForConversionPerCampaign: StrategyPayForConversionPerCampaign = field(default=None)
    PayForConversionPerFilter: StrategyPayForConversionPerFilter = field(default=None)


@dataclass
class SmartCampaignStrategy:
    Search: SmartCampaignSearchStrategy = field(default=None)
    Network: SmartCampaignNetworkStrategy = field(default=None)


@dataclass
class SmartCampaignSettingGet:
    Option: SmartCampaignSettingsGetEnum = field(default=None)
    Value: YesNoEnum = field(default=None)


@dataclass
class SmartCampaignGetItem:
    CounterId: int = field(default=None)
    AttributionModel: AttributionModelEnum = field(default=None)
    BiddingStrategy: SmartCampaignStrategy = field(default=None)
    Settings: List[SmartCampaignSettingGet] = field(default=None)
    PriorityGoals: PriorityGoalsArray = field(default=None)


@dataclass
class CampaignGetItem:
    DailyBudget: DailyBudgetClass = field(default=None)
    Id: int = field(default=None)
    Name: str = field(default=None)
    ClientInfo: str = field(default=None)
    StartDate: str = field(default=None)
    TimeTargeting: TimeTargetingClass = field(default=None)
    TimeZone: str = field(default=None)
    NegativeKeywords: ArrayOfString = field(default=None)
    Type: CampaignTypeGetEnum = field(default=None)
    Status: StatusEnum = field(default=None)
    State: CampaignStateGetEnum = field(default=None)
    StatusPayment: CampaignStatusPaymentEnum = field(default=None)
    StatusClarification: str = field(default=None)
    Statistics: StatisticsClass = field(default=None)
    Currency: CurrencyEnum = field(default=None)
    Funds: FundsParam = field(default=None)
    RepresentedBy: CampaignAssistant = field(default=None)
    Notification: NotificationClass = field(default=None)
    ExcludedSites: ArrayOfString = field(default=None)
    TextCampaign: TextCampaignGetItem = field(default=None)
    MobileAppCampaign: MobileAppCampaignGetItem = field(default=None)
    DynamicTextCampaign: DynamicTextCampaignGetItem = field(default=None)
    CpmBannerCampaign: CpmBannerCampaignGetItem = field(default=None)
    SmartCampaign: SmartCampaignGetItem = field(default=None)
    EndDate: str = field(default=None)
    SourceId: int = field(default=None)
    BlockedIps: ArrayOfString = field(default=None)


@dataclass
class result:
    Campaigns: List[CampaignGetItem] = field(default=None)
    LimitedBy: int = field(default=None)
