from typing import List
from dataclasses import dataclass, field
from crm.supskills.common.direct_client.structs.enums.general import YesNoEnum, CurrencyEnum
from crm.supskills.common.direct_client.structs.enums.clients import EmailSubscriptionEnum, PrivilegeEnum, \
    ClientRestrictionEnum, ClientSettingGetEnum, RepresentativeRoleEnum
from crm.supskills.common.direct_client.structs.enums.general import LangEnum


@dataclass
class EmailSubscriptionItem:
    Option: EmailSubscriptionEnum = field(default=None)
    Value: YesNoEnum = field(default=None)


@dataclass
class ClientRestrictionItem:
    Element: ClientRestrictionEnum = field(default=None)
    Value: int = field(default=None)


@dataclass
class ClientSettingGetItem:
    Option: ClientSettingGetEnum = field(default=None)
    Value: YesNoEnum = field(default=None)


@dataclass
class BonusesGet:
    AwaitingBonus: float = field(default=None)
    AwaitingBonusWithoutNds: float = field(default=None)


@dataclass
class NotificationGet:
    Lang: LangEnum = field(default=None)
    SmsPhoneNumber: str = field(default=None)
    Email: str = field(default=None)
    EmailSubscriptions: List[EmailSubscriptionItem] = field(default=None)


@dataclass
class GrantGetItem:
    Privilege: PrivilegeEnum = field(default=None)
    Value: YesNoEnum = field(default=None)
    Agency: str = field(default=None)


@dataclass
class Representative:
    Login: str = field(default=None)
    Email: str = field(default=None)
    Role: RepresentativeRoleEnum = field(default=None)


@dataclass
class ClientGetItem:
    AccountQuality: float = field(default=None)
    Archived: YesNoEnum = field(default=None)
    ClientId: int = field(default=None)
    ClientInfo: str = field(default=None)
    CountryId: int = field(default=None)
    CreatedAt: str = field(default=None)
    Currency: CurrencyEnum = field(default=None)
    Grants: List[GrantGetItem] = field(default=None)
    Bonuses: BonusesGet = field(default=None)
    Login: str = field(default=None)
    Notification: NotificationGet = field(default=None)
    OverdraftSumAvailable: int = field(default=None)
    Phone: str = field(default=None)
    Representatives: List[Representative] = field(default=None)
    Restrictions: List[ClientRestrictionItem] = field(default=None)
    Settings: List[ClientSettingGetItem] = field(default=None)
    Type: str = field(default=None)
    VatRate: float = field(default=None)


@dataclass
class result:
    Clients: List[ClientGetItem] = field(default=None)
