from typing import List, Any
from dataclasses import dataclass, field
from crm.supskills.common.direct_client.structs.enums.feeds import FeedStatusEnum
from crm.supskills.common.direct_client.structs.enums.general import YesNoEnum

BusinessTypeEnum = Any
SourceTypeEnum = Any


@dataclass
class UrlFeedGet:
    Url: str = field(default=None)
    Login: str = field(default=None)
    RemoveUtmTags: YesNoEnum = field(default=None)


@dataclass
class FileFeedGet:
    Filename: str = field(default=None)


@dataclass
class FeedGetItem:
    Id: int = field(default=None)
    Name: str = field(default=None)
    BusinessType: BusinessTypeEnum = field(default=None)
    SourceType: SourceTypeEnum = field(default=None)
    FilterSchema: str = field(default=None)
    UpdatedAt: str = field(default=None)
    CampaignIds: List[int] = field(default=None)
    FileFeed: FileFeedGet = field(default=None)
    NumberOfItems: int = field(default=None)
    Status: FeedStatusEnum = field(default=None)
    UrlFeed: UrlFeedGet = field(default=None)


@dataclass
class result:
    Feeds: List[FeedGetItem] = field(default=None)
    LimitedBy: int = field(default=None)
