import click
from aiohttp import web


_common_options = [
    click.option('port', '-p', '--port', envvar='PORT', type=int, help='Port to start instance.', required=True)
]


def common_options(func):
    for option in reversed(_common_options):
        func = option(func)
    return func


def run_app(app_factory, options):
    port = options.pop('port')
    app = app_factory()
    web.run_app(app, port=port)
