from aiohttp import web
from crm.supskills.common.bunker_client.bunker import Bunker
from crm.supskills.common.direct_client.api_v4 import Direct4
from crm.supskills.common.direct_client.api_v5 import Direct5, EnvType
from crm.supskills.common.tvm2 import TvmServiceMiddleware
from crm.supskills.common.tvm2 import get_tvm_client
from crm.supskills.direct_skill.src.config import tvm_config, app_config
from crm.supskills.direct_skill.src.views.dialog_handler import DialogHandler
from crm.supskills.direct_skill.src.views.ping import ping


def create_app():
    max_count_of_intents_in_request = app_config.max_count_of_intents_in_request
    bunker = Bunker(app_config.environment, app_config.bunker_time_delta)
    direct5_client = Direct5(EnvType(app_config.environment), app_config.oauth_token_direct)
    direct4_client = Direct4(EnvType(app_config.environment), app_config.oauth_token_direct)
    handler = DialogHandler(max_count_of_intents_in_request, bunker, direct5_client, direct4_client)

    app = web.Application(middlewares=[
        TvmServiceMiddleware(tvm_client=get_tvm_client(tvm_config),
                             tvm2_active=tvm_config.tvm2_active)
    ])
    app.router.add_get('/ping', ping, name='ping')
    app.router.add_post('/', handler.post)

    app['app_config'] = app_config
    return app
