import environ
import datetime
from tvmauth import BlackboxTvmId


def _list_converter(val):
    """Convert str to list of ints."""
    val_lst = val.strip().split(',')
    return [int(i) for i in val_lst]


@environ.config
class TvmConfig:
    check_async = environ.var(name='TVM2_ASYNC', default='1')  # need to set any true value
    tvm2_client_id = environ.var(name='TVM2_CLIENT_ID', converter=int, default=2026678)
    tvm2_blackbox = environ.var(name='TVM2_BLACKBOX', default=BlackboxTvmId.Prod)
    tvm2_active = environ.bool_var(name='TVM2_ACTIVE', default=False)
    tvm2_allowed_client_ids = environ.var(name='TVM2_ALLOWED_CLIENT_IDS', default='2026678', converter=_list_converter)


@environ.config
class AppConfig:
    bunker_time_delta = environ.var(default=datetime.timedelta(0, 0, 0, 0, 5))
    max_count_of_intents_in_request = environ.var(name='MAX_COUNT_OF_INTENTS_IN_REQUEST', converter=int, default=5)
    oauth_token_direct = environ.var(name='OAUTH_TOKEN_DIRECT', converter=str, default='Bad oauth token!')
    environment = environ.var(name='YENV_TYPE', converter=str, default='production')


tvm_config = environ.to_config(TvmConfig)
app_config = environ.to_config(AppConfig)
