# -*- coding: utf-8 -*-
import random


class Conversation:
    def __init__(self, request, response, user_state):
        self.request = request
        self.response = response
        self.user_state = user_state

    def reply(self, text, buttons=None, end_session=False, floyd_exit_node=None):
        self.response.update(text=text, buttons=buttons, end_session=end_session, floyd_exit_node=floyd_exit_node)

    def reply_random(self, texts, buttons=None, end_session=False):
        if not isinstance(texts, list):
            texts = [texts]
        self.response.update(text=random.choice(texts), buttons=buttons, end_session=end_session)

    def update_state(self, **states):
        self.user_state.update(states)

    def get_utterance_tokens(self):
        return self.request['nlu']['tokens']
