from abc import ABCMeta, abstractmethod


class Intent(metaclass=ABCMeta):
    def __init__(self, bunker):
        self.bunker = bunker

    @abstractmethod
    async def act(self, *args, **kwargs):
        """
        Reply to user's intent.
        Args:
            conversation (obj) - required
            state (str) - optional
        """
        pass
