from abc import ABCMeta
from crm.supskills.direct_skill.src.core.models.intent import Intent
from crm.supskills.direct_skill.src.core.models.button import Button


class SimpleIntent(Intent, metaclass=ABCMeta):
    name = ''
    state = ''
    text = ''
    buttons = []
    state_to_set = ''
    end_session = False
    floyd_exit_node = None

    async def build_text(self):
        if isinstance(self.text, tuple):
            return await self.bunker.get_node(self.text[0], self.text[1])
        else:
            return self.text

    async def build_buttons(self):
        processed_buttons = []

        for button in self.buttons:
            try:
                processed_buttons.append(Button(await self.bunker.get_node(*button[0]), await self.bunker.get_node(*button[1])))
            except TypeError:
                processed_buttons.append(Button(await self.bunker.get_node(*button)))

        return processed_buttons

    async def act(self, conversation, *args, **kwargs):
        conversation.reply(await self.build_text(), await self.build_buttons(), end_session=self.end_session, floyd_exit_node=self.floyd_exit_node)
        if self.state_to_set:
            conversation.update_state(state=self.state_to_set)
