# -*- coding: utf-8 -*-
from marshmallow import Schema, fields
from crm.supskills.direct_skill.src.core.schemas.response import SessionStateSchema


class SingleSlotSchema(Schema):
    type = fields.String()
    value = fields.String()


class NluSchema(Schema):
    intents = fields.Mapping(
        keys=fields.String(),
        values=fields.Mapping(
            keys=fields.String(),
            values=fields.Nested(SingleSlotSchema())))
    tokens = fields.List(fields.String())
    entities = fields.List(fields.Nested(SingleSlotSchema()))


class FloydUser(Schema):
    puid = fields.String()
    login = fields.String()
    operator_chat_id = fields.String()


class SessionSchema(Schema):
    session_id = fields.String()
    new = fields.Boolean()
    user_id = fields.String()
    floyd_user = fields.Nested(FloydUser())


class StateSchema(Schema):
    session = fields.Nested(SessionStateSchema())


class RequestSchema(Schema):
    original_utterance = fields.String()
    nlu = fields.Nested(NluSchema())


class FinalRequestSchema(Schema):
    state = fields.Nested(StateSchema())
    request = fields.Nested(RequestSchema())
    session = fields.Nested(SessionSchema())
    version = fields.String()
