# -*- coding: utf-8 -*-
from marshmallow import Schema, fields


class SessionStateSchema(Schema):
    state = fields.String()
    empty_intents_count = fields.Integer()


class ButtonSchema(Schema):
    title = fields.String()
    hide = fields.Boolean()
    url = fields.Url()


class ButtonOnImageSchema(Schema):
    text = fields.String()
    url = fields.Url()


class CardSchema(Schema):
    type = fields.String(required=True)
    image_id = fields.String()
    description = fields.String()
    title = fields.String()
    button = fields.Nested(ButtonOnImageSchema())


class ResponseSchema(Schema):
    end_session = fields.Boolean(required=True)
    floyd_exit_node = fields.String()
    text = fields.String(required=True)
    buttons = fields.Nested(ButtonSchema(), many=True)
    tts = fields.String()
    card = fields.Nested(CardSchema())


class AnalyticsEventSchema(Schema):
    name = fields.String()
    value = fields.Dict()


class AnalyticsSchema(Schema):
    events = fields.List(fields.Nested(AnalyticsEventSchema()))


class FinalResponseSchema(Schema):
    version = fields.String(required=True)
    session = fields.String()
    response = fields.Nested(ResponseSchema(), required=True)
    session_state = fields.Nested(SessionStateSchema())
    analytics = fields.Nested(AnalyticsSchema())
