import os


# helps to create necessary files for one scenario branch
# input name of a branch with spaces e.g. 'stop campaign'


def write_to_file(fname, content):

    with open(fname, 'w') as f:
        f.write(content)


def convert_to_snake_case(lst_of_str):

    return '_'.join(lst_of_str)


def convert_to_camel_case(lst_of_str):

    return ''.join(st.capitalize() for st in lst_of_str)


def create_intent_draft(name, home_dir, path):
    os.chdir(home_dir + '/intents' + path)

    snake_name = convert_to_snake_case(name)
    camel_name = convert_to_camel_case(name)
    file_name = '{}.py'.format(snake_name)
    dot_path = path.replace('/', '.') + '.' + snake_name

    draft_intent = '''from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.intents.general.rejection_intent import Rejection
from crm.supskills.direct_skill.src.intents.general.confirmation_intent import Confirmation
from crm.supskills.direct_skill.src.consts.scenario.buttons{0} import {2}
from crm.supskills.direct_skill.src.consts.scenario.utterances{0} import {3}


class {4}General(GeneralTopicIntent):
    name = '{1}'
    text = {3}.  # TODO: fill out the draft
    buttons = [{2}.]  # TODO: fill out the draft
    state_to_set = 'TODO'  # TODO: fill out the draft
'''.format(dot_path, snake_name + '_general_topic', snake_name + '_buttons', snake_name + '_utterances', camel_name)

    write_to_file(file_name, draft_intent)


def create_scenario_draft(name, home_dir, path):
    os.chdir(home_dir + '/consts/scenario/utterances' + path)
    snake_name = convert_to_snake_case(name)
    upper_snake_name = snake_name.upper()
    camel_name = convert_to_camel_case(name)
    file_name = '{}.py'.format(snake_name)

    draft_scenario = '''class {1}Utterances:
    path = 'scenario/utterances/TODO/{0}' # TODO: fill out the draft

    @property
    def {0}_(self):  # TODO: fill out the draft
        return self.path, '{3}_'  # TODO: fill out the draft


{0}_utterances = {1}Utterances()
'''.format(snake_name, camel_name, path, upper_snake_name)

    write_to_file(file_name, draft_scenario)


def create_buttons_draft(name, home_dir, path):
    os.chdir(home_dir + '/consts/scenario/buttons' + path)
    snake_name = convert_to_snake_case(name)
    upper_snake_name = snake_name.upper()
    camel_name = convert_to_camel_case(name)
    file_name = '{}.py'.format(snake_name)

    draft_buttons = '''class {1}:
    path = 'scenario/buttons/TODO/{0}' # TODO: fill out the draft

    @property
    def {0}_(self):  # TODO: fill out the draft
        return self.path, '{3}_'  # TODO: fill out the draft


{0}_buttons = {1}()

'''.format(snake_name, camel_name, path, upper_snake_name)

    write_to_file(file_name, draft_buttons)


def create_scenario():
    name = ['']
    path = '/campaign/campaign_parameters'
    home = os.getcwd()

    create_buttons_draft(name, home, path)
    create_scenario_draft(name, home, path)
    create_intent_draft(name, home, path)


create_scenario()
