from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.consts.scenario.utterances.account.account_representatives import account_utterances
from crm.supskills.direct_skill.src.consts.scenario.buttons.account.account_representatives import account_buttons
from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.intents.general.confirmation_intent import Confirmation
from crm.supskills.direct_skill.src.intents.general.rejection_intent import Rejection


class GrantAccessGeneralTopic(GeneralTopicIntent):
    name = 'grant_access_general_topic'
    text = account_utterances.grant_access_options
    buttons = [account_buttons.grant_access_to_account,
               account_buttons.grant_access_to_balance]


class AccountGrantAccess(FinalIntent):
    name = 'account_how_to_grant_access'
    text = account_utterances.how_to_grant_access


class AccountAddRepresentativeHowto(FinalIntent):
    name = 'account_add_representative_howto'
    text = account_utterances.how_to_add_representative


class AccountDeleteRepresentative(FinalIntent):
    name = 'account_delete_representative_howto'
    text = account_utterances.account_delete_representative_howto


class AccountDeleteRepresentativeError(FinalIntent):
    name = 'account_delete_representative_error'
    text = account_utterances.account_delete_representative_error


class AccountRestrictAccess(FinalIntent):
    name = 'account_restrict_access_howto'
    text = account_utterances.account_restrict_access_howto


class AccountAssignNewRep(SimpleIntent):
    name = 'account_assign_new_main_representative'
    text = account_utterances.if_there_is_access_to_current_main_representative
    state_to_set = 'if_there_is_access_to_current_main_representative'


class AccountAssignNewRepYes(Confirmation, FinalIntent):
    state = 'if_there_is_access_to_current_main_representative'
    text = account_utterances.account_assign_new_main_representative_self


class AccountAssignNewRepNo(Rejection, FinalIntent):
    state = 'if_there_is_access_to_current_main_representative'
    text = account_utterances.account_assign_new_main_representative_support
