from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.consts.scenario.utterances.default import default_utterances
from crm.supskills.direct_skill.src.intents.general.rejection_intent import Rejection
from crm.supskills.direct_skill.src.intents.general.confirmation_intent import Confirmation
from crm.supskills.direct_skill.src.consts.scenario.utterances.account.account_representatives import account_utterances


class CannotAddRepresentative(SimpleIntent):
    name = 'cannot_add_representative'
    text = account_utterances.is_main_rep
    state_to_set = 'is_main_rep'


class MainRepresentativeRejection(Rejection, FinalIntent):
    state = 'is_main_rep'
    text = account_utterances.not_main_rep


class MainRepresentativeConfirmation(Confirmation):
    state = 'is_main_rep'
    text = account_utterances.is_login_new
    state_to_set = 'is_login_new'
    end_session = False


class NewLoginRejection(Rejection, FinalIntent):
    state = 'is_login_new'
    text = account_utterances.not_new_login


class NewLoginConfirmation(Confirmation):
    state = 'is_login_new'
    text = account_utterances.is_email
    state_to_set = 'is_correct_login'
    end_session = False


class CorrectLoginRejection(Rejection):
    state = 'is_correct_login'
    text = default_utterances.sorry
    state_to_set = 'is_correct_login'


class CorrectLoginConfirmation(Confirmation):
    state = 'is_correct_login'
    text = default_utterances.cannot_help
    state_to_set = 'is_main_rep, is_login_new, is_correct_login'
