from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.intents.general.rejection_intent import Rejection
from crm.supskills.direct_skill.src.intents.general.confirmation_intent import Confirmation
from crm.supskills.direct_skill.src.consts.scenario.buttons.ad.ad_actions import ad_actions_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.ad.ad_actions import ad_actions_utterances


class AdActionsGeneral(GeneralTopicIntent):
    name = 'ad_actions_general_topic'
    text = ad_actions_utterances.ad_actions_general_topic
    buttons = [ad_actions_buttons.ad_actions_add,
               ad_actions_buttons.ad_actions_delete]


class AdActionsAdd(SimpleIntent):
    name = 'ad_actions_add'
    text = ad_actions_utterances.is_to_existing_group
    state_to_set = 'is_to_existing_group'


class AdActionsAddToExistingGroup(FinalIntent, Confirmation):
    state = 'is_to_existing_group'
    text = ad_actions_utterances.add_to_existing_group


class AdActionsAddToNewGroup(FinalIntent, Rejection):
    state = 'is_to_existing_group'
    text = ad_actions_utterances.add_to_new_group


class AdActionsDelete(FinalIntent):
    name = 'ad_actions_delete'
    text = ad_actions_utterances.ad_actions_delete


class AdActionsAddVideo(FinalIntent):
    name = 'ad_actions_add_video'
    text = ad_actions_utterances.ad_actions_add_video


class AdActionsDisplayedLink(FinalIntent):
    name = 'ad_actions_displayed_link'
    text = ad_actions_utterances.ad_actions_displayed_link
