from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.consts.scenario.buttons.ad.ad_graphic import ad_graphic_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.ad.ad_graphic import ad_graphic_utterances


class AdGraphicGeneral(GeneralTopicIntent):
    name = 'ad_graphic_general_topic'
    text = ad_graphic_utterances.ad_graphic_options
    buttons = [ad_graphic_buttons.ad_graphic_create,
               ad_graphic_buttons.ad_graphic_edit,
               ad_graphic_buttons.ad_graphic_creative]


class AdGraphicCreate(FinalIntent):
    name = 'ad_graphic_create'
    text = ad_graphic_utterances.ad_graphic_create


class AdGraphicEdit(FinalIntent):
    name = 'ad_graphic_edit'
    text = ad_graphic_utterances.ad_graphic_edit


class AdGraphicCreativeAdaptiveSize(FinalIntent):
    name = 'ad_graphic_creative_adaptive_size'
    text = ad_graphic_utterances.ad_graphic_creative_adaptive_size


class AdGraphicCreativeVariousSize(FinalIntent):
    name = 'ad_graphic_creative_various_size'
    text = ad_graphic_utterances.ad_graphic_creative_various_size


class AdGraphicCreativeExport(FinalIntent):
    name = 'ad_graphic_creative_export'
    text = ad_graphic_utterances.ad_graphic_creative_export


class AdGraphicCreativeAddFromLibrary(FinalIntent):
    name = 'ad_graphic_creative_add_from_library'
    text = ad_graphic_utterances.ad_graphic_creative_add_from_library
