from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.consts.scenario.buttons.ad.ad_images import ad_images_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.ad.ad_images import ad_images_utterances


class AdImagesGeneral(GeneralTopicIntent):
    name = 'ad_images_general_topic'
    text = ad_images_utterances.ad_images_general_topic
    buttons = [ad_images_buttons.ad_images_add,
               ad_images_buttons.ad_images_requirements,
               ad_images_buttons.ad_images_smart,
               ad_images_buttons.ad_images_error]


class AdImagesError(FinalIntent):
    name = 'ad_images_error'
    text = ad_images_utterances.ad_images_error


class AdImagesSmart(FinalIntent):
    name = 'ad_images_smart'
    text = ad_images_utterances.ad_images_smart


class AdImagesAdd(GeneralTopicIntent):
    name = 'ad_images_add_general_topic'
    text = ad_images_utterances.ad_images_add_general_topic
    buttons = [ad_images_buttons.ad_images_add_when_edit,
               ad_images_buttons.ad_images_add_many,
               ad_images_buttons.ad_images_no_link]


class AdImagesAddWhenEdit(FinalIntent):
    name = 'ad_images_add_when_edit'
    text = ad_images_utterances.ad_images_add_when_edit


class AdImagesAddMany(FinalIntent):
    name = 'ad_images_add_many'
    text = ad_images_utterances.ad_images_add_many


class AdImagesAddNoLink(FinalIntent):
    name = 'ad_images_no_link'
    text = ad_images_utterances.ad_images_no_link


class AdImagesRequirementsGeneral(GeneralTopicIntent):
    name = 'ad_images_requirements_general_topic'
    text = ad_images_utterances.ad_images_requirements_general_topic
    buttons = [ad_images_buttons.ad_images_requirements_standard,
               ad_images_buttons.ad_images_requirements_wide]


class AdImagesRequirementsWide(FinalIntent):
    name = 'ad_images_requirements_wide'
    text = ad_images_utterances.ad_images_requirements_wide


class AdImagesRequirementsStandard(FinalIntent):
    name = 'ad_images_requirements_standard'
    text = ad_images_utterances.ad_images_requirements_standard
