from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.consts.scenario.buttons.ad.turbo_site import turbo_site_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.ad.turbo_site import turbo_site_utterances


class TurboSiteGeneral(GeneralTopicIntent):
    name = 'turbo_site_general_topic'
    text = turbo_site_utterances.turbo_site_options
    buttons = [turbo_site_buttons.turbo_site_create_new,
               turbo_site_buttons.turbo_site_delete,
               turbo_site_buttons.turbo_site_create_based_on_old,
               turbo_site_buttons.turbo_site_move,
               turbo_site_buttons.turbo_site_access,
               turbo_site_buttons.turbo_site_copy_link,
               turbo_site_buttons.turbo_site_change_address,
               turbo_site_buttons.turbo_site_domen_taken,
               turbo_site_buttons.turbo_site_change_name]


class TurboSiteCreateNew(SimpleIntent):
    name = 'turbo_site_create_new'
    text = turbo_site_utterances.turbo_site_create_new
    buttons = [turbo_site_buttons.turbo_site_create_based_on_old]


class TurboSiteCreateBasedOnOld(FinalIntent):
    name = 'turbo_site_create_based_on_old'
    text = turbo_site_utterances.turbo_site_create_based_on_old


class TurboSiteDelete(FinalIntent):
    name = 'turbo_site_delete'
    text = turbo_site_utterances.turbo_site_delete


class TurboSiteMove(FinalIntent):
    name = 'turbo_site_move'
    text = turbo_site_utterances.turbo_site_move


class TurboSiteAccess(FinalIntent):
    name = 'turbo_site_access'
    text = turbo_site_utterances.turbo_site_access


class TurboSiteCopyLink(FinalIntent):
    name = 'turbo_site_copy_link'
    text = turbo_site_utterances.turbo_site_copy_link


class TurboSiteChangeAddress(FinalIntent):
    name = 'turbo_site_change_address'
    text = turbo_site_utterances.turbo_site_change_address


class TurboSiteDomenTaken(FinalIntent):
    name = 'turbo_site_domen_taken'
    text = turbo_site_utterances.turbo_site_domen_taken


class TurboSiteChangeName(FinalIntent):
    name = 'turbo_site_change_name'
    text = turbo_site_utterances.turbo_site_change_name
