from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.consts.scenario.utterances.ads_group.ads_group_actions import ads_group_utterances
from crm.supskills.direct_skill.src.consts.scenario.buttons.ads_group.ads_group_actions import ad_group_actions_buttons
from crm.supskills.direct_skill.src.intents.general.confirmation_intent import Confirmation
from crm.supskills.direct_skill.src.intents.general.rejection_intent import Rejection


class AdsGroupTurnOn(FinalIntent):
    name = 'ads_group_turnon'
    text = ads_group_utterances.ads_group_turnon


class AdsGroupDelete(FinalIntent):
    name = 'ads_group_delete'
    text = ads_group_utterances.ads_group_delete


class AdsGroupArchive(FinalIntent):
    name = 'ads_group_archive'
    text = ads_group_utterances.ads_group_archive


class AdsGroupAdd(FinalIntent):
    name = 'ads_group_add'
    text = ads_group_utterances.ads_group_add


class AdsGroupCopy(FinalIntent):
    name = 'ads_group_copy'
    text = ads_group_utterances.ads_group_copy


class AdsGroupEditGeneral(GeneralTopicIntent):
    name = 'ads_group_edit_general_topic'
    text = ads_group_utterances.ads_group_edit_other
    buttons = [ad_group_actions_buttons.ads_group_edit_tags,
               ad_group_actions_buttons.ads_group_edit_minus_words,
               ad_group_actions_buttons.ads_group_edit_region,
               ad_group_actions_buttons.ads_group_cancel,
               ad_group_actions_buttons.ads_group_edit_one_key,
               ad_group_actions_buttons.ads_group_error]


class AdsGroupTags(FinalIntent):
    name = 'ads_group_edit_tags'
    text = ads_group_utterances.ads_group_edit_tags


class AdsGroupMinusWords(FinalIntent):
    name = 'ads_group_edit_minus_words'
    text = ads_group_utterances.ads_group_edit_minus_words


class AdsGroupRegions(FinalIntent):
    name = 'ads_group_edit_region'
    text = ads_group_utterances.ads_group_edit_region


class AdsGroupEditCancel(FinalIntent):
    name = 'ads_group_edit_cancel'
    text = ads_group_utterances.ads_group_edit_cancel


class AdsGroupEditOneKey(FinalIntent):
    name = 'ads_group_edit_one_key'
    text = ads_group_utterances.ads_group_edit_one_key


class AdsGroupEditError(SimpleIntent):
    name = 'ads_group_error'
    text = ads_group_utterances.if_system_warning
    state_to_set = 'if_system_warning'


class AdsGroupEditErrorWarningYes(FinalIntent, Confirmation):
    state = 'if_system_warning'
    text = ads_group_utterances.show_conditions_not_added


class AdsGroupEditErrorWarningNo(FinalIntent, Rejection):
    state = 'if_system_warning'
    text = ads_group_utterances.other_reasons


class AdsGroupEditFastLink(FinalIntent):
    name = 'ads_group_edit_fast_links'
    text = ads_group_utterances.ads_group_edit_fast_links
