from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.consts.scenario.buttons.campaign.campaign_actions.campaign_copy import campaign_copy_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.campaign.campaign_actions.campaign_copy import campaign_copy_utterances


class CampaignCopyGeneral(GeneralTopicIntent):
    name = 'campaign_copy_general_topic'
    text = campaign_copy_utterances.copy_options
    buttons = [campaign_copy_buttons.copy_in_login]


class CampaignCopyInLoginSelf(GeneralTopicIntent):
    name = 'campaign_copy_in_login_self'
    text = campaign_copy_utterances.self_client
    buttons = [campaign_copy_buttons.copy_with_excel,
               campaign_copy_buttons.copy_with_direct,
               campaign_copy_buttons.copy_with_commander]


class CampaignCopyInLoginSelfExcel(FinalIntent):
    name = 'campaign_copy_in_login_self_excel'
    text = campaign_copy_utterances.copy_with_excel


class CampaignCopyInLoginSelfDirect(FinalIntent):
    name = 'campaign_copy_in_login_self_direct'
    text = campaign_copy_utterances.copy_with_direct


class CampaignCopyInLoginSelfCommander(FinalIntent):
    name = 'campaign_copy_in_login_self_commander'
    text = campaign_copy_utterances.copy_with_commander
