from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.intents.general.rejection_intent import Rejection
from crm.supskills.direct_skill.src.intents.general.confirmation_intent import Confirmation
from crm.supskills.direct_skill.src.consts.scenario.buttons.campaign.campaign_actions.campaign_howto_send_to_moderation import campaign_howto_send_to_moderation_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.campaign.campaign_actions.campaign_howto_send_to_moderation import campaign_howto_send_to_moderation_utterances


class CampaignHowtoSendToModerationGeneral(SimpleIntent):
    name = 'howto_send_to_moderation_general_topic'
    text = campaign_howto_send_to_moderation_utterances.if_send_button_exists
    state_to_set = 'if_send_button_exists'


class CampaignHowtoSendToModerationIfSendExistsConfirmation(Confirmation):
    state = 'if_send_button_exists'
    text = campaign_howto_send_to_moderation_utterances.is_one_or_many
    buttons = [campaign_howto_send_to_moderation_buttons.one_campaign_to_send,
               campaign_howto_send_to_moderation_buttons.many_campaigns_to_send]


class CampaignHowtoSendToModerationIfSendExistsRejection(Rejection):
    state = 'if_send_button_exists'
    text = campaign_howto_send_to_moderation_utterances.to_operator
    end_session = True


class CampaignHowtoSendToModerationOne(FinalIntent):
    name = 'howto_send_to_moderation_one'
    text = campaign_howto_send_to_moderation_utterances.send_one_campaign_template


class CampaignHowtoSendToModerationMany(FinalIntent):
    name = 'howto_send_to_moderation_many'
    text = campaign_howto_send_to_moderation_utterances.send_many_campaigns_template
