from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.consts.scenario.buttons.campaign.campaign_actions.create_campaign_buttons import create_campaign_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.campaign.campaign_actions.campaign_create import campaign_create_utterances
from crm.supskills.direct_skill.src.intents.general.rejection_intent import Rejection
from crm.supskills.direct_skill.src.intents.general.confirmation_intent import Confirmation


class CreateCampaignAgency(FinalIntent):
    name = 'create_campaign_agency'
    text = campaign_create_utterances.agency_help


class CreateCampaignDirect(FinalIntent):
    name = 'create_campaign_direct'
    text = campaign_create_utterances.direct_help


class CreateCampaignYandex(FinalIntent):
    name = 'create_campaign_yandex'
    text = campaign_create_utterances.yandex_help


class CreateCampaignPro(SimpleIntent):
    name = 'create_campaign_pro'
    text = campaign_create_utterances.professional_help_options
    buttons = [create_campaign_buttons.yandex_help,
               create_campaign_buttons.direct_help,
               create_campaign_buttons.agency_help]


class CreateCampaign(GeneralTopicIntent):
    name = 'create_campaign_general_topic'
    text = campaign_create_utterances.select_creation_method
    buttons = [create_campaign_buttons.professional_support,
               create_campaign_buttons.self_creation]


class CreateCampaignSelf(SimpleIntent):
    name = 'create_campaign_self'
    text = campaign_create_utterances.if_login_exists
    state_to_set = 'if_direct_login_created'


class LoginCreatedRejection(Rejection):
    state = 'if_direct_login_created'
    text = campaign_create_utterances.create_login
    buttons = [create_campaign_buttons.created_login_next_step]
    state_to_set = 'if_direct_login_created'


class LoginCreatedConfirmation(Confirmation, FinalIntent):
    state = 'if_direct_login_created'
    text = campaign_create_utterances.create_first_campaign
