from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.consts.scenario.buttons.campaign.campaign_actions.delete_campaign_buttons import delete_campaign_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.campaign.campaign_actions.campaign_delete import campaign_delete_utterances
from crm.supskills.direct_skill.src.intents.general.rejection_intent import Rejection
from crm.supskills.direct_skill.src.intents.general.confirmation_intent import Confirmation


class DeleteCampaign(SimpleIntent):
    name = 'delete_campaign_general_topic'
    text = campaign_delete_utterances.check_delete_button
    state_to_set = 'if_delete_button_exists'


class DeletePresentRejection(Rejection):
    state = 'if_delete_button_exists'
    text = campaign_delete_utterances.only_archive_possible
    buttons = [delete_campaign_buttons.archive_option]


class DeletePresentConfirmation(Confirmation):
    state = 'if_delete_button_exists'
    text = campaign_delete_utterances.is_one_of_many
    buttons = [delete_campaign_buttons.one_campaign_to_delete,
               delete_campaign_buttons.many_campaigns_to_delete]


class DeleteOneCampaign(FinalIntent):
    name = 'delete_one_campaign'
    text = campaign_delete_utterances.delete_one_campaign_template


class DeleteManyCampaigns(FinalIntent):
    name = 'delete_many_campaigns'
    text = campaign_delete_utterances.delete_many_campaigns_template
