import asyncio

from crm.supskills.common.direct_client.structs.enums.ad_groups import AdGroupTypesEnum, AdGroupSubtypeEnum
from crm.supskills.common.direct_client.structs.enums.feeds import FeedStatusEnum
from crm.supskills.common.direct_client.structs.enums.general import StatusEnum
from crm.supskills.common.direct_client.structs.structs.ad_groups import AdGroupGetItem, ServingStatusEnum
from crm.supskills.common.direct_client.structs.structs.campaigns import CampaignStateGetEnum
from crm.supskills.common.direct_client.structs.structs.feeds import FeedGetItem
from crm.supskills.direct_skill.src.consts.scenario.buttons.campaign.campaign_parameters.campaign_status import \
    campaign_status_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.campaign.campaign_parameters.campaign_status import \
    campaign_status_utterances
from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.intents.general.call_operator_intent import CallOperatorWithText
from crm.supskills.direct_skill.src.intents.general.simple_direct_intent import SimpleDirectIntent


class CampaignStatusGeneral(GeneralTopicIntent):
    name = 'campaign_status_general_topic'
    state_to_set = 'campaign_number_requested_campaign_status'
    text = campaign_status_utterances.campaign_status_options
    buttons = [campaign_status_buttons.campaign_status_info]


def extract_feeds_ids(ad_groups: [AdGroupGetItem]) -> list:
    feeds_ids = []
    for ad_group in ad_groups:
        if ad_group.Type == AdGroupTypesEnum.SMART_AD_GROUP:
            feeds_ids.append(ad_group.SmartAdGroup.FeedId)
        elif ad_group.Type == AdGroupTypesEnum.DYNAMIC_TEXT_AD_GROUP and ad_group.Subtype == AdGroupSubtypeEnum.FEED:
            feeds_ids.append(ad_group.DynamicTextFeedAdGroup.FeedId)
    return list(set(feeds_ids))


class CampaignStatusNumber(SimpleDirectIntent):
    name = 'numbers_general_topic'
    state = 'campaign_number_requested_campaign_status'

    async def select_direct_intent(self, conversation, direct5, direct4, login, campaigns, groups, ads):
        return await CampaignStatusNumberGeneralTopic.select_direct_intent(self, conversation, direct5, direct4, login, campaigns, groups, ads)


class CampaignStatusNumberGeneralTopic(SimpleDirectIntent):
    name = 'campaign_status_number_general_topic'
    state = ''

    async def select_direct_intent(self, conversation, direct5, direct4, login, campaigns, groups, ads):
        if campaigns:
            campaign = campaigns[0]
            ad_groups, accounts = await asyncio.gather(*[direct5.get_ad_groups(login, campaign.Id),
                                                         direct4.get_account_management(login)],
                                                       return_exceptions=True)

            if campaign.State == CampaignStateGetEnum.ON:
                return 'campaign_status_going_shows', ''
            if campaign.State == CampaignStateGetEnum.ARCHIVED:
                return 'campaign_status_archive', ''
            if campaign.State == CampaignStateGetEnum.SUSPENDED:
                return 'campaign_status_stopped', ''
            if campaign.State == CampaignStateGetEnum.OFF:
                if campaign.Status == StatusEnum.MODERATION:
                    return 'campaign_status_under_moderation', ''
                if campaign.Status == StatusEnum.DRAFT:
                    return 'campaign_status_draft', ''
                if campaign.Status == StatusEnum.REJECTED:
                    return 'campaign_status_problem_moderation_refusal', ''
                if campaign.Status == StatusEnum.ACCEPTED or campaign.Status == StatusEnum.REJECTED:
                    if accounts and accounts[0].Amount <= 0:
                        return 'campaign_status_no_going_shows', ''
            if all([ad_group.ServingStatus == ServingStatusEnum.RARELY_SERVED for ad_group in ad_groups]):
                return 'campaign_status_problem_small_targeting_groups', ''
            feed_ids = extract_feeds_ids(ad_groups)
            if feed_ids:
                feeds: [FeedGetItem] = await direct5.get_feeds(login, feed_ids)
                if feeds:
                    if all([feed.Status != FeedStatusEnum.DONE for feed in feeds]):
                        return 'campaign_status_problem_in_processing_or_not_created', ''
            return 'campaign_status_not_recognized', ''
        else:
            return 'call_operator', ''


class CampaignStatusInfo(SimpleIntent):
    name = 'campaign_status_info_general_topic'
    text = campaign_status_utterances.campaign_status_info
    buttons = [campaign_status_buttons.campaign_status_draft,
               campaign_status_buttons.campaign_status_activation_continues,
               campaign_status_buttons.campaign_status_under_moderation,
               campaign_status_buttons.campaign_status_going_shows,
               campaign_status_buttons.campaign_status_no_going_shows,
               campaign_status_buttons.campaign_status_archive,
               campaign_status_buttons.campaign_status_stopped,
               campaign_status_buttons.campaign_status_suspended,
               campaign_status_buttons.campaign_status_problem]


class CampaignStatusProblem(GeneralTopicIntent):
    name = 'campaign_status_problem_general_topic'
    text = campaign_status_utterances.campaign_status_problem
    buttons = [campaign_status_buttons.campaign_status_problem_moderation_refusal,
               campaign_status_buttons.campaign_status_problem_in_processing_or_not_created,
               campaign_status_buttons.campaign_status_problem_groups_with_legal_restriction,
               campaign_status_buttons.campaign_status_problem_restriction_by_behavior,
               campaign_status_buttons.campaign_status_problem_small_targeting_groups]


class CampaignStatusNotRecognized(CallOperatorWithText):
    name = 'campaign_status_not_recognized'
    text = campaign_status_utterances.campaign_status_not_recognized


class CampaignStatusDraft(FinalIntent):
    name = 'campaign_status_draft'
    text = campaign_status_utterances.campaign_status_draft


class CampaignStatusUnderModeration(FinalIntent):
    name = 'campaign_status_under_moderation'
    text = campaign_status_utterances.campaign_status_under_moderation


class CampaignStatusNoGoingShows(FinalIntent):
    name = 'campaign_status_no_going_shows'
    text = campaign_status_utterances.campaign_status_no_going_shows


class CampaignStatusGoingShows(FinalIntent):
    name = 'campaign_status_going_shows'
    text = campaign_status_utterances.campaign_status_going_shows


class CampaignStatusSuspended(FinalIntent):
    name = 'campaign_status_suspended'
    text = campaign_status_utterances.campaign_status_suspended


class CampaignStatusStopped(FinalIntent):
    name = 'campaign_status_stopped'
    text = campaign_status_utterances.campaign_status_stopped


class CampaignStatusArchive(FinalIntent):
    name = 'campaign_status_archive'
    text = campaign_status_utterances.campaign_status_archive


class CampaignStatusActivationContinues(FinalIntent):
    name = 'campaign_status_activation_continues'
    text = campaign_status_utterances.campaign_status_activation_continues


class CampaignStatusProblemRestrictionByBehavior(FinalIntent):
    name = 'campaign_status_problem_restriction_by_behavior'
    text = campaign_status_utterances.campaign_status_problem_restriction_by_behavior


class CampaignStatusProblemSmallTargetingGroups(FinalIntent):
    name = 'campaign_status_problem_small_targeting_groups'
    text = campaign_status_utterances.campaign_status_problem_small_targeting_groups


class CampaignStatusProblemModerationRefusal(FinalIntent):
    name = 'campaign_status_problem_moderation_refusal'
    text = campaign_status_utterances.campaign_status_problem_moderation_refusal


class CampaignStatusProblemInProcessingOrNotCreated(FinalIntent):
    name = 'campaign_status_problem_in_processing_or_not_created'
    text = campaign_status_utterances.campaign_status_problem_in_processing_or_not_created


class CampaignStatusProblemGroupsWithLegalRestriction(FinalIntent):
    name = 'campaign_status_problem_groups_with_legal_restriction'
    text = campaign_status_utterances.campaign_status_problem_groups_with_legal_restriction
