from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.consts.scenario.buttons.campaign.campaign_parameters.geotargeting import geotargeting_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.campaign.campaign_parameters.geotargeting import geotargeting_utterances


class GeotargetingGeneral(GeneralTopicIntent):
    name = 'geotargeting_general_topic'
    text = geotargeting_utterances.geotargeting_options
    buttons = [geotargeting_buttons.howto_set_geotargeting_option,
               geotargeting_buttons.howto_change_region_geotargeting_option,
               geotargeting_buttons.geotargeting_statistics,
               geotargeting_buttons.howto_set_region_geotargeting_option,
               geotargeting_buttons.extended_geotargeting_option]


class GeotargetingHowtoSet(SimpleIntent):
    name = 'geotargeting_howto_set'
    text = geotargeting_utterances.howto_set_geotargeting
    buttons = [geotargeting_buttons.geotargeting_statistics]


class GeotargetingHowtoStats(FinalIntent):
    name = 'geotargeting_statistics'
    text = geotargeting_utterances.geotargeting_statistics


class GeotargetingHowtoChangeRegion(SimpleIntent):
    name = 'geotargeting_howto_change_region'
    text = geotargeting_utterances.is_one_or_many
    buttons = [geotargeting_buttons.many_campaigns_to_change,
               geotargeting_buttons.one_campaign_to_change]


class GeotargetingHowtoSetRegion(FinalIntent):
    name = 'geotargeting_howto_set_region'
    text = geotargeting_utterances.howto_set_region_geotargeting


class GeotargetingHowtoChangeRegionOne(FinalIntent):
    name = 'geotargeting_howto_change_region_one'
    text = geotargeting_utterances.change_one_campaign_template


class GeotargetingHowtoChangeRegionMany(FinalIntent):
    name = 'geotargeting_howto_change_region_many'
    text = geotargeting_utterances.change_many_campaigns_template


class GeotargetingExtended(SimpleIntent):
    name = 'geotargeting_extended'
    text = geotargeting_utterances.geotargeting_extended_howto
    buttons = [geotargeting_buttons.geotargeting_extended_nets,
               geotargeting_buttons.geotargeting_extended_search]


class GeotargetingExtendedNets(FinalIntent):
    name = 'geotargeting_extended_nets'
    text = geotargeting_utterances.geotargeting_extended_nets


class GeotargetingExtendedSearch(FinalIntent):
    name = 'geotargeting_extended_search'
    text = geotargeting_utterances.geotargeting_extended_search
