from crm.supskills.direct_skill.src.intents.general.numbers_intent import Numbers
from crm.supskills.direct_skill.src.consts.scenario.utterances.campaign.campaign_parameters.monitoring import monitoring_utterances
from crm.supskills.direct_skill.src.intents.general.number_request import NumberRequest
from crm.supskills.direct_skill.src.intents.general.rejection_intent import Rejection


class MonitoringIssuesNumberRequested(NumberRequest):
    name = 'monitoring_performance_issue'
    state_to_set = 'campaign_number_requested_monitoring_issue'
    text = monitoring_utterances.asking_ad_number


class MonitoringIssuesNotHelped(Rejection):
    state = 'if_time_solved_problem'

    def act(conversation, *args, **kwargs):
        conversation.reply(monitoring_utterances.access_logs_request, end_session=True)


class MonitoringIssues(Numbers):
    state = 'campaign_number_requested_monitoring_issue'

    def act(conversation, *args, **kwargs):
        # check ad parameters - monitorings

        # if parameter is off:
        # conversation.reply(monitoring_utterances.PARAMETER_TURNED_OFF)
        # conversation.update_state(state='final_node')

        # else check ad status

        # if status == inactive
        # conversation.reply(monitoring_utterances.WRONG_STATUS)
        # conversation.update_state(state='final_node')

        # else ping main page

        # if main page doesnt respond
        # conversation.reply(monitoring_utterances.MAIN_PAGE_INACTIVE)
        # conversation.update_state(state='final_node')

        # if main page redirects to hosting page and responds ok
        # conversation.reply(monitoring_utterances.HOSTING_PAGE)
        # conversation.update_state(state='final_node')

        # else check if turbo pages present

        # if turbo pages
        # conversation.reply(monitoring_utterances.TURBO_PAGES)
        # conversation.update_state(state='final_node')

        # else
        conversation.reply(monitoring_utterances.please_wait)
        conversation.update_state(state='if_time_solved_problem')

