from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.consts.scenario.buttons.campaign.campaign_types.dynamic_ads_create import dynamic_ads_create_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.campaign.campaign_types.dynamic_ads_create import dynamic_ads_create_utterances
from crm.supskills.direct_skill.src.consts.scenario.buttons.campaign.campaign_types.dynamic_ads_feed import dynamic_ads_feed_buttons


class DynamicAdsCreateGeneral(GeneralTopicIntent):
    name = 'dynamic_ads_general_topic'
    text = dynamic_ads_create_utterances.dynamic_ads_options
    buttons = [dynamic_ads_create_buttons.how_to_create,
               dynamic_ads_create_buttons.creation_howto,
               dynamic_ads_create_buttons.pricing]


class DynamicAdsCreate(SimpleIntent):
    name = 'dynamic_ads_create'
    text = dynamic_ads_create_utterances.how_to_create
    buttons = [dynamic_ads_feed_buttons.more_about_feed]


class DynamicAdsCreatePricing(FinalIntent):
    name = 'dynamic_ads_pricing'
    text = dynamic_ads_create_utterances.pricing


class DynamicAdsCreateSettingGeneral(SimpleIntent):
    name = 'dynamic_ads_set_howto'
    text = dynamic_ads_create_utterances.general_setting
    buttons = [dynamic_ads_create_buttons.target_setting,
               dynamic_ads_create_buttons.filter_setting]


class DynamicAdsCreateFilterSetting(FinalIntent):
    name = 'dynamic_ads_filter_setting'
    text = dynamic_ads_create_utterances.filter_setting


class DynamicAdsCreateTargetSetting(FinalIntent):
    name = 'dynamic_ads_target_setting'
    text = dynamic_ads_create_utterances.target_setting
