from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.consts.scenario.buttons.campaign.campaign_types.media_campaign_banner import media_campaign_banner_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.campaign.campaign_types.media_campaign_banner import media_campaign_banner_utterances
from crm.supskills.direct_skill.src.consts.scenario.buttons.ad.ad_graphic import ad_graphic_buttons


class MediaCampaignBannerGeneral(GeneralTopicIntent):
    name = 'media_campaign_banner_general_topic'
    text = media_campaign_banner_utterances.banner_options
    buttons = [media_campaign_banner_buttons.howto_create,
               media_campaign_banner_buttons.banner_keywords,
               media_campaign_banner_buttons.banner_stopwords,
               media_campaign_banner_buttons.banner_price,
               media_campaign_banner_buttons.banner_creative]


class MediaCampaignBannerKeyword(FinalIntent):
    name = 'media_campaign_banner_keyword'
    text = media_campaign_banner_utterances.banner_keywords


class MediaCampaignBannerStopWord(FinalIntent):
    name = 'media_campaign_banner_stopword'
    text = media_campaign_banner_utterances.banner_stopwords


class MediaCampaignBannerPrice(FinalIntent):
    name = 'media_campaign_banner_price'
    text = media_campaign_banner_utterances.banner_price


class MediaCampaignBannerHowto(FinalIntent):
    name = 'media_campaign_banner_howto'
    text = media_campaign_banner_utterances.howto_create


class MediaCampaignBannerCreative(GeneralTopicIntent):
    name = 'media_campaign_banner_creative'
    text = media_campaign_banner_utterances.banner_creative_options
    buttons = [media_campaign_banner_buttons.banner_creative_constructor,
               media_campaign_banner_buttons.banner_creative_upload_from_computer]


class MediaCampaignBannerCreativeConstructor(GeneralTopicIntent):
    name = 'media_campaign_banner_creative_constructor'
    text = media_campaign_banner_utterances.banner_creative_constructor
    buttons = [ad_graphic_buttons.ad_graphic_creative_adaptive_size,
               ad_graphic_buttons.ad_graphic_creative_various_size,
               ad_graphic_buttons.ad_graphic_creative_export,
               ad_graphic_buttons.ad_graphic_creative_add_from_library]


class MediaCampaignBannerCreativeUploadFromComputer(FinalIntent):
    name = 'media_campaign_banner_creative_upload_from_computer'
    text = media_campaign_banner_utterances.banner_creative_upload_from_computer
