from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.consts.scenario.buttons.campaign.campaign_types.search_banner import search_banner_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.campaign.campaign_types.search_banner import search_banner_utterances


class SearchBannerGeneral(GeneralTopicIntent):
    name = 'search_banner_general_topic'
    text = search_banner_utterances.search_banner_options
    buttons = [search_banner_buttons.search_banner_create,
               search_banner_buttons.search_banner_price,
               search_banner_buttons.search_banner_settings_problem]


class SearchBannerCreate(FinalIntent):
    name = 'search_banner_create'
    text = search_banner_utterances.search_banner_create


class SearchBannerPrice(FinalIntent):
    name = 'search_banner_price'
    text = search_banner_utterances.search_banner_price


class SearchBannerSettingsGeneral(GeneralTopicIntent):
    name = 'search_banner_settings_general_topic'
    text = search_banner_utterances.search_banner_settings_options
    buttons = [search_banner_buttons.search_banner_setting_show_conditions,
               search_banner_buttons.search_banner_setting_strategies,
               search_banner_buttons.search_banner_settings_requirements,
               search_banner_buttons.search_banner_settings_moderation]


class SearchBannerSettingsShowConditions(FinalIntent):
    name = 'search_banner_setting_show_conditions'
    text = search_banner_utterances.search_banner_setting_show_conditions


class SearchBannerStrategies(GeneralTopicIntent):
    name = 'search_banner_setting_strategies_general_topic'
    text = search_banner_utterances.search_banner_setting_strategies_options
    buttons = [search_banner_buttons.search_banner_setting_strategies_manual,
               search_banner_buttons.search_banner_setting_strategies_click_optimization]


class SearchBannerStrategiesManual(SimpleIntent):
    name = 'search_banner_setting_strategies_manual'
    text = search_banner_utterances.search_banner_setting_strategies_manual
    buttons = [search_banner_buttons.search_banner_setting_strategies_click_optimization]


class SearchBannerStrategiesClickOptimization(SimpleIntent):
    name = 'search_banner_setting_strategies_click_optimization'
    text = search_banner_utterances.search_banner_setting_strategies_click_optimization
    buttons = [search_banner_buttons.search_banner_setting_strategies_manual]


class SearchBannerRequirements(FinalIntent):
    name = 'search_banner_settings_requirements'
    text = search_banner_utterances.search_banner_settings_requirements


class SearchBannerModeration(FinalIntent):
    name = 'search_banner_settings_moderation'
    text = search_banner_utterances.search_banner_settings_moderation
