from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.consts.scenario.buttons.feedback.feedback_contact_us import feedback_contact_us_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.feedback.feedback_contact_us import feedback_contact_us_utterances


class FeedbackContactUsGeneral(GeneralTopicIntent):
    name = 'feedback_contact_us_general_topic'
    text = feedback_contact_us_utterances.feedback_options
    buttons = [feedback_contact_us_buttons.feedback_call_me,
               feedback_contact_us_buttons.feedback_howto_call,
               feedback_contact_us_buttons.feedback_howto_email,
               feedback_contact_us_buttons.feedback_howto_leave_feedback]


class FeedbackContactUsCall(FinalIntent):
    name = 'feedback_contact_us_call'
    text = feedback_contact_us_utterances.feedback_howto_call


class FeedbackContactUsEmail(FinalIntent):
    name = 'feedback_contact_us_email'
    text = feedback_contact_us_utterances.feedback_howto_email


class FeedbackContactUsRequestCall(FinalIntent):
    name = 'feedback_contact_us_request_call'
    text = feedback_contact_us_utterances.feedback_call_me


class FeedbackContactUsLeaveFeedback(FinalIntent):
    name = 'feedback_contact_us_leave_feedback'
    text = feedback_contact_us_utterances.feedback_howto_leave_feedback
