from crm.supskills.direct_skill.src.consts.scenario.utterances.ask_topic import ask_topic_utterances
from crm.supskills.direct_skill.src.consts.scenario.utterances.default import default_utterances
from crm.supskills.direct_skill.src.core.models.button import Button
from crm.supskills.direct_skill.src.core.models.general_topic_intent import SimpleIntent


class AskTopic(SimpleIntent):
    name = 'ask_topic'

    async def act(self, conversation, buttons) -> (str, str):
        async def build_text(text) -> str:
            if isinstance(text, tuple):
                return await self.bunker.get_node(text[0], text[1])
            else:
                return await text

        buttons.append(Button(await self.bunker.get_node(*default_utterances.no_relevant_topic)))
        conversation.reply(await build_text(ask_topic_utterances.pick_topic), buttons)
        return AskTopic.name, AskTopic.state
