import asyncio
import re

from crm.supskills.common.deploy_logger import create_logger
from crm.supskills.common.direct_client.api_v5 import CampaignGetItem, AdGroupGetItem, AdGetItem
from crm.supskills.common.direct_client.api_v5 import DirectAPIError, DirectKeyError, DirectNetError
from crm.supskills.direct_skill.src.intents.general.numbers_intent import Numbers


logger = create_logger('direct_intent_logger')


class SimpleDirectIntent(Numbers):
    state = '___forbidden_state___simple_direct_intent_state'

    @staticmethod
    async def __get_data_from_ids(ids, direct5, direct4, login):
        campaigns, groups, ads, single_campaign = await asyncio.gather(*[direct5.get_campaigns_by_ids(login, ids),
                                                                         direct5.get_ad_groups_by_ids(login, ids),
                                                                         direct5.get_ads_by_ids(login, ids),
                                                                         direct5.get_single_campaign(login)],
                                                                       return_exceptions=True)
        if isinstance(single_campaign, CampaignGetItem):
            campaigns = [single_campaign]
        campaigns = [i for i in campaigns if isinstance(i, CampaignGetItem)] if isinstance(campaigns, list) else []
        groups = [i for i in groups if isinstance(i, AdGroupGetItem)] if isinstance(groups, list) else []
        ads = [i for i in ads if isinstance(i, AdGetItem)] if isinstance(ads, list) else []
        logger.info('Campaigns: %d, Groups: %d, Ads: %d', len(campaigns), len(groups), len(ads))
        return campaigns, groups, ads

    def get_login(self, conversation):
        floyd_user = conversation.request['session'].get('floyd_user')
        if floyd_user and floyd_user.get('login'):
            return floyd_user.get('login')
        else:
            logger.error('Error: No login in request!')
            return None

    async def get_data(self, conversation, login, direct5, direct4, *args, **kwargs):
        if args:
            return args[0], args[1], args[2]  # campaigns, groups, ads
        else:
            nlu = conversation.request['request'].get('nlu')
            if nlu and nlu.get('tokens'):
                entities = nlu.get('tokens')
                get_ids = re.compile(r'[\d]{3,}')
                return await self.__get_data_from_ids(
                    [int(j) for entity in entities for j in get_ids.findall(entity)], direct5, direct4, login)
            else:
                return await self.__get_data_from_ids([], direct5, direct4, login)

    async def check_direct_data(self, conversation, direct5, direct4, *args, **kwargs):

        login = self.get_login(conversation)
        intent, state = 'call_operator', ''
        if login:
            try:
                campaigns, groups, ads = await self.get_data(conversation, login, direct5, direct4, *args)
                intent, state = await self.select_direct_intent(conversation,
                                                                direct5, direct4,
                                                                login, campaigns, groups, ads)
            except (DirectKeyError, DirectAPIError, DirectNetError) as e:
                logger.error('Error: %s!', str(e))

        return intent, state

    async def select_direct_intent(self, conversation, direct5, direct4, login, campaigns, groups, ads):
        return 'intent_name', 'intent_state'
