from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.intents.general.confirmation_intent import Confirmation
from crm.supskills.direct_skill.src.consts.scenario.utterances.moderation.moderation_docs_request import moderation_docs_request_utterances
from crm.supskills.direct_skill.src.intents.general.call_operator_intent import CallOperatorWithText


class ModerationDocsRequest(SimpleIntent):
    name = 'moderation_docs_request'
    text = moderation_docs_request_utterances.if_notification_seen
    state_to_set = 'if_notification_seen'


class ModerationDocsRequestNotificationNo(CallOperatorWithText):
    name = 'YANDEX_REJECT'
    state = 'if_notification_seen'


class ModerationDocsRequestNotificationYes(Confirmation):
    state = 'if_notification_seen'
    text = moderation_docs_request_utterances.if_category_detected_correctly
    state_to_set = 'if_category_detected_correctly'


class ModerationDocsRequestCategoryDetectedNo(CallOperatorWithText):
    name = 'YANDEX_REJECT'
    state = 'if_category_detected_correctly'


class ModerationDocsRequestCategoryDetectedYes(Confirmation):
    state = 'if_category_detected_correctly'
    text = moderation_docs_request_utterances.if_ready_to_send_docs_later
    state_to_set = 'if_ready_to_send_docs_later'


class ModerationDocsRequestSendLaterNo(CallOperatorWithText):
    name = 'YANDEX_REJECT'
    state = 'if_ready_to_send_docs_later'


class ModerationDocsRequestSendLaterYes(Confirmation, FinalIntent):
    state = 'if_ready_to_send_docs_later'
    text = moderation_docs_request_utterances.ready_to_send_docs_later
