from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.intents.general.rejection_intent import Rejection
from crm.supskills.direct_skill.src.intents.general.confirmation_intent import Confirmation
from crm.supskills.direct_skill.src.consts.scenario.utterances.moderation.moderation_long import moderation_long_utterances
from crm.supskills.direct_skill.src.intents.general.call_operator_intent import CallOperatorWithText


class ModerationLong(SimpleIntent):
    name = 'moderation_long'
    text = moderation_long_utterances.if_24_hours_passed
    state_to_set = 'if_24_hours_passed'


class ModerationLong24HoursPassedNo(FinalIntent, Rejection):
    state = 'if_24_hours_passed'
    text = moderation_long_utterances.no_moderation_delay


class ModerationLong24HoursPassedYes(Confirmation):
    state = 'if_24_hours_passed'
    text = moderation_long_utterances.if_notification_present
    state_to_set = 'if_notification_present'


class ModerationLongNotificationPresentNo(CallOperatorWithText):
    name = 'YANDEX_REJECT'
    state = 'if_notification_present'


class ModerationLongNotificationPresentYes(FinalIntent, Confirmation):
    state = 'if_notification_present'
    text = moderation_long_utterances.notification_present
