from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.consts.scenario.buttons.pay.autopayment import autopayment_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.pay.autopayment import autopayment_utterances


class AutopaymentGeneral(GeneralTopicIntent):
    name = 'autopayment_general_topic'
    text = autopayment_utterances.autopayment_general_topic
    buttons = [autopayment_buttons.autopayment_info,
               autopayment_buttons.autopayment_enable,
               autopayment_buttons.autopayment_disable]  # TODO: there must be 5 buttons. 2 need to call direct.


class AutopaymentEnable(SimpleIntent):
    name = 'autopayment_enable'
    text = autopayment_utterances.autopayment_enable
    buttons = [autopayment_buttons.autopayment_enable_for_legal_entity,
               autopayment_buttons.autopayment_enable_can_not_bind_card]


class AutopaymentDisable(FinalIntent):
    name = 'autopayment_disable'
    text = autopayment_utterances.autopayment_disable


class AutopaymentEnableForLegalEntity(FinalIntent):
    name = 'autopayment_enable_for_legal_entity'
    text = autopayment_utterances.autopayment_enable_for_legal_entity


class AutopaymentInfo(FinalIntent):
    name = 'autopayment_info'
    text = autopayment_utterances.autopayment_info


class AutopaymentEnableCanNotBindCard(FinalIntent):
    name = 'autopayment_enable_can_not_bind_card'
    text = autopayment_utterances.autopayment_enable_can_not_bind_card


class AutopaymentDisabledButMoneyIsDebited(FinalIntent):
    name = 'autopayment_disabled_but_money_is_debited'
    text = autopayment_utterances.autopayment_disabled_but_money_is_debited


class AutopaymentEnabledButMoneyIsNotDebitedYamoney(FinalIntent):
    name = 'autopayment_enabled_but_money_is_not_debited_yamoney'
    text = autopayment_utterances.autopayment_enabled_but_money_is_not_debited_yamoney


class AutopaymentEnabledButMoneyIsNotDebitedCard(FinalIntent):
    name = 'autopayment_enabled_but_money_is_not_debited_card'
    text = autopayment_utterances.autopayment_enabled_but_money_is_not_debited_card
