from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.consts.scenario.buttons.general_buttons import general_buttons
from crm.supskills.direct_skill.src.consts.scenario.buttons.pay.closing_documents import closing_documents_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.pay.closing_documents import closing_documents_utterances
from crm.supskills.direct_skill.src.intents.general.confirmation_intent import Confirmation
from crm.supskills.direct_skill.src.intents.general.call_operator_intent import CallOperatorWithText


class ClosingDocumentsGeneral(GeneralTopicIntent):
    name = 'closing_documents_general_topic'
    text = closing_documents_utterances.closing_documents_options
    buttons = [closing_documents_buttons.closing_documents_howto,
               closing_documents_buttons.closing_documents_workflow_turn_on,
               closing_documents_buttons.docs_needed,
               closing_documents_buttons.closing_documents_not_received]


class ClosingDocumentsDocflowTurnOn(FinalIntent):
    name = 'closing_documents_docflow_turn_on'
    text = closing_documents_utterances.closing_documents_workflow_turn_on


class ClosingDocumentsHowto(SimpleIntent):
    name = 'closing_documents_howto'
    text = closing_documents_utterances.closing_documents_howto_options
    buttons = [closing_documents_buttons.closing_documents_get_individual,
               closing_documents_buttons.closing_documents_get_legal]


class ClosingDocumentsHowtoIndividual(FinalIntent):
    name = 'closing_documents_get_individual'
    text = closing_documents_utterances.closing_documents_get_individual


class ClosingDocumentsHowtoLegal(FinalIntent):
    name = 'closing_documents_get_legal'
    text = closing_documents_utterances.closing_documents_get_legal


class ClosingDocumentsNeeded(SimpleIntent):
    name = 'closing_documents_needed'
    text = closing_documents_utterances.docs_needed
    buttons = [general_buttons.to_operator]


class ClosingDocumentsNotReceived(SimpleIntent):
    name = 'closing_documents_not_received'
    text = closing_documents_utterances.is_docflow_on
    state_to_set = 'is_docflow_on'


class ClosingDocumentsNotReceivedDocflowOn(Confirmation, FinalIntent):
    text = closing_documents_utterances.closing_documents_not_received
    state = 'is_docflow_on'


class ClosingDocumentsNotReceivedDocflowOff(CallOperatorWithText):
    name = 'YANDEX_REJECT'
    state = 'is_docflow_on'
