from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.intents.general.rejection_intent import Rejection
from crm.supskills.direct_skill.src.intents.general.confirmation_intent import Confirmation
from crm.supskills.direct_skill.src.consts.scenario.buttons.pay.overdraft import overdraft_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.pay.overdraft import overdraft_utterances
from crm.supskills.direct_skill.src.intents.general.call_operator_intent import CallOperatorWithText


class OverdraftGeneral(GeneralTopicIntent):
    name = 'overdraft_general_topic'
    text = overdraft_utterances.overdraft_general_topic
    buttons = [overdraft_buttons.overdraft_howto_use,
               overdraft_buttons.overdraft_timeline,
               overdraft_buttons.overdraft_available_sum_lowered,
               overdraft_buttons.overdraft_howto_repay,
               overdraft_buttons.overdraft_unavailable]


class OverdraftHowToUse(FinalIntent):
    name = 'overdraft_howto_use'
    text = overdraft_utterances.overdraft_howto_use


class OverdraftTimeline(FinalIntent):
    name = 'overdraft_timeline'
    text = overdraft_utterances.overdraft_timeline


class OverdraftAvailableSumLowered(FinalIntent):
    name = 'overdraft_available_sum_lowered'
    text = overdraft_utterances.overdraft_available_sum_lowered


class OverdraftHowToRepay(GeneralTopicIntent):
    name = 'overdraft_howto_repay_general_topic'
    text = overdraft_utterances.overdraft_howto_repay
    buttons = [overdraft_buttons.overdraft_howto_repay_joint_account,
               overdraft_buttons.overdraft_howto_change_account]


class OverdraftRepayWithJoinAccount(FinalIntent):
    name = 'overdraft_howto_repay_joint_account'
    text = overdraft_utterances.overdraft_howto_repay_joint_account


class OverdraftChangeAccount(FinalIntent):
    name = 'overdraft_howto_change_account'
    text = overdraft_utterances.overdraft_howto_change_account


class OverdraftUnavailable(SimpleIntent):
    name = 'overdraft_unavailable'
    text = overdraft_utterances.is_cut_off_threshold
    state_to_set = 'is_cut_off_threshold'


class OverdraftUnavailableThresholdOn(FinalIntent, Confirmation):
    state = 'is_cut_off_threshold'
    text = overdraft_utterances.cut_off_threshold_on


class OverdraftUnavailableThresholdOff(Rejection):
    state = 'is_cut_off_threshold'
    text = overdraft_utterances.is_agency
    state_to_set = 'is_agency'


class OverdraftUnavailableAgencyYes(FinalIntent, Confirmation):
    state = 'is_agency'
    text = overdraft_utterances.unavailable_for_agencies


class OverdraftUnavailableAgencyNo(Rejection):
    state = 'is_agency'
    text = overdraft_utterances.is_debt
    state_to_set = 'is_debt'


class OverdraftUnavailableDebtYes(FinalIntent, Confirmation):
    state = 'is_debt'
    text = overdraft_utterances.unavailable_with_debt


class OverdraftUnavailableDebtNo(Rejection):
    state = 'is_debt'
    text = overdraft_utterances.is_country_suitable
    state_to_set = 'is_country_suitable'


class OverdraftUnavailableCountrySuitable(CallOperatorWithText):
    name = 'YANDEX_CONFIRM'
    state = 'is_country_suitable'


class OverdraftUnavailableCountryNotSuitable(FinalIntent, Rejection):
    state = 'is_country_suitable'
    text = overdraft_utterances.country_not_suitable
