from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.consts.scenario.buttons.pay.pay_balance_interface import pay_balance_interface_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.pay.pay_balance_interface import pay_balance_interface_utterances


class PayBalanceInterfaceGeneral(GeneralTopicIntent):
    name = 'balance_interface_general_topic'
    text = pay_balance_interface_utterances.balance_interface_options
    buttons = [pay_balance_interface_buttons.balance_interface_access_to_accountant,
               pay_balance_interface_buttons.balance_interface_funds_movement,
               pay_balance_interface_buttons.balance_interface_see_balance,
               pay_balance_interface_buttons.balance_interface_delete_account]


class PayBalanceInterfaceSeeBalance(FinalIntent):
    name = 'balance_interface_see_balance'
    text = pay_balance_interface_utterances.balance_interface_see_balance


class PayBalanceInterfaceAccessAccountant(FinalIntent):
    name = 'balance_interface_access_to_accountant'
    text = pay_balance_interface_utterances.balance_interface_access_to_accountant


class PayBalanceInterfaceFundMovement(FinalIntent):
    name = 'balance_interface_fund_movement'
    text = pay_balance_interface_utterances.balance_interface_funds_movement


class PayBalanceInterfaceDeleteAccount(FinalIntent):
    name = 'balance_interface_delete_account'
    text = pay_balance_interface_utterances.balance_interface_delete_account
