from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.intents.general.rejection_intent import Rejection
from crm.supskills.direct_skill.src.intents.general.confirmation_intent import Confirmation
from crm.supskills.direct_skill.src.consts.scenario.buttons.pay.pay_deposits import pay_deposits_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.pay.pay_deposits import pay_deposits_utterances
from crm.supskills.direct_skill.src.intents.general.call_operator_intent import CallOperatorWithText
from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent


class PayDepositsGeneral(GeneralTopicIntent):
    name = 'pay_deposits_general_topic'
    text = pay_deposits_utterances.pay_deposits_options
    buttons = [pay_deposits_buttons.pay_deposits_timeline,
               pay_deposits_buttons.pay_deposits_wrong_payer,
               pay_deposits_buttons.pay_deposits_wrong_sum,
               pay_deposits_buttons.pay_deposits_money_lost]


class PayDepositsTimeline(FinalIntent):
    name = 'pay_deposits_timeline'
    text = pay_deposits_utterances.pay_deposits_timeline


class PayDepositsErrorInPayment(FinalIntent):
    name = 'pay_deposits_error'
    text = pay_deposits_utterances.transfer_to_fos


class PayDepositsMoneyLost(SimpleIntent):
    name = 'pay_deposits_money_lost'
    text = pay_deposits_utterances.pay_deposits_money_lost
    state_to_set = 'if_sum_paid_equals_to_sum_in_invoice'


class PayDepositsSumEqualsRejection(FinalIntent, Rejection):
    state = 'if_sum_paid_equals_to_sum_in_invoice'
    text = pay_deposits_utterances.pay_deposits_sum_equals


class PayDepositsSumEqualsConfirmation(Confirmation):
    state = 'if_sum_paid_equals_to_sum_in_invoice'
    text = pay_deposits_utterances.if_debt_on_account
    state_to_set = 'if_debt_on_account'


class PayDepositsDebtPresentConfirmation(FinalIntent, Confirmation):
    state = 'if_debt_on_account'
    text = pay_deposits_utterances.pay_deposits_dept_present


class PayDepositsDebtPresentRejection(CallOperatorWithText):
    name = 'YANDEX_REJECT'
    state = 'if_debt_on_account'
