from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.intents.general.rejection_intent import Rejection
from crm.supskills.direct_skill.src.intents.general.confirmation_intent import Confirmation
from crm.supskills.direct_skill.src.consts.scenario.buttons.pay.pay_issue_invoice import pay_issue_invoice_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.pay.pay_issue_invoice import pay_issue_invoice_utterances


class PayIssueInvoiceGeneral(GeneralTopicIntent):
    name = 'pay_issue_invoice_general_topic'
    text = pay_issue_invoice_utterances.joint_account_options
    buttons = [pay_issue_invoice_buttons.issue_invoice_option,
               pay_issue_invoice_buttons.invoice_request,
               pay_issue_invoice_buttons.issue_invoice_individual,
               pay_issue_invoice_buttons.issue_invoice_legal,
               pay_issue_invoice_buttons.issue_invoice_valid_days,
               pay_issue_invoice_buttons.pay_issue_invoice_change_method,
               pay_issue_invoice_buttons.pay_issue_united_individual_account,
               pay_issue_invoice_buttons.pay_issue_invoice_minimum_sum]


class PayIssueInvoiceHowto(SimpleIntent):
    name = 'pay_issue_invoice_howto'
    text = pay_issue_invoice_utterances.is_joint_account
    state_to_set = 'is_joint_account'


class PayIssueInvoiceJointAccountConfirmation(Confirmation, FinalIntent):
    state = 'is_joint_account'
    text = pay_issue_invoice_utterances.joint_account_issue_invoice


class PayIssueInvoiceJointAccountRejection(Rejection, FinalIntent):
    state = 'is_joint_account'
    text = pay_issue_invoice_utterances.no_joint_account_issue_invoice


class PayIssueInvoiceRequest(FinalIntent):
    name = 'pay_issue_invoice_request'
    text = pay_issue_invoice_utterances.invoice_request


class PayIssueInvoiceIndividual(FinalIntent):
    name = 'pay_issue_invoice_individual'
    text = pay_issue_invoice_utterances.issue_invoice_individual


class PayIssueInvoiceLegal(FinalIntent):
    name = 'pay_issue_invoice_legal'
    text = pay_issue_invoice_utterances.issue_invoice_legal


class PayIssueInvoiceValidDays(FinalIntent):
    name = 'pay_issue_invoice_valid_days'
    text = pay_issue_invoice_utterances.issue_invoice_valid_days


class PayIssueInvoiceIndividualAccount(FinalIntent):
    name = 'pay_issue_invoice_united_individual_account'
    text = pay_issue_invoice_utterances.pay_issue_united_individual_account


class PayIssueInvoiceMinimumSum(FinalIntent):
    name = 'pay_issue_invoice_minimum_sum'
    text = pay_issue_invoice_utterances.pay_issue_invoice_minimum_sum


class PayIssueInvoiceChangePaymentMethod(GeneralTopicIntent):
    name = 'pay_issue_invoice_change_method_general_topic'
    text = pay_issue_invoice_utterances.pay_issue_invoice_change_method_general_topic
    buttons = [pay_issue_invoice_buttons.pay_issue_change_method_payment_in_process,
               pay_issue_invoice_buttons.pay_issue_change_method_in_issued_invoice,
               pay_issue_invoice_buttons.pay_issue_change_method_delayed_payment]


class PayIssueInvoiceChangePaymentMethodInProgress(FinalIntent):
    name = 'pay_issue_change_method_payment_in_process'
    text = pay_issue_invoice_utterances.pay_issue_change_method_payment_in_process


class PayIssueInvoiceChangePaymentMethodInIssuedInvoice(FinalIntent):
    name = 'pay_issue_change_method_in_issued_invoice'
    text = pay_issue_invoice_utterances.pay_issue_change_method_in_issued_invoice
