from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.intents.general.rejection_intent import Rejection
from crm.supskills.direct_skill.src.intents.general.confirmation_intent import Confirmation
from crm.supskills.direct_skill.src.consts.scenario.buttons.pay.pay_methods import pay_methods_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.pay.pay_methods import pay_methods_utterances
from crm.supskills.direct_skill.src.intents.general.call_operator_intent import CallOperator, CallOperatorWithText


class PayMethodsGeneral(GeneralTopicIntent):
    name = 'pay_methods_general_topic'
    text = pay_methods_utterances.pay_methods_options
    buttons = [pay_methods_buttons.pay_card,
               pay_methods_buttons.pay_cash,
               pay_methods_buttons.pay_account,
               pay_methods_buttons.pay_internet_bank,
               pay_methods_buttons.pay_paypal,
               pay_methods_buttons.pay_receipt,
               pay_methods_buttons.pay_qiwi,
               pay_methods_buttons.pay_yandex_money,
               pay_methods_buttons.pay_webmoney]


class PayMethodsCard(FinalIntent):
    name = 'pay_methods_card'
    text = pay_methods_utterances.pay_card


class PayMethodsQiwi(FinalIntent):
    name = 'pay_methods_qiwi'
    text = pay_methods_utterances.pay_qiwi


class PayMethodsAccount(FinalIntent):
    name = 'pay_methods_account'
    text = pay_methods_utterances.pay_account


class PayMethodsInternetBank(FinalIntent):
    name = 'pay_methods_internet_bank'
    text = pay_methods_utterances.pay_internet_bank


class PayMethodsReceipt(FinalIntent):
    name = 'pay_methods_receipt'
    text = pay_methods_utterances.pay_receipt


class PayMethodsWebmoney(FinalIntent):
    name = 'pay_methods_webmoney'
    text = pay_methods_utterances.pay_webmoney


class PayMethodsCash(SimpleIntent):
    name = 'pay_methods_cash'
    text = pay_methods_utterances.pay_cash
    buttons = [pay_methods_buttons.pay_cash_passport,
               pay_methods_buttons.pay_cash_change_amount,
               pay_methods_buttons.pay_cash_deleted_sms]


class PayMethodsCashPassport(FinalIntent):
    name = 'pay_cash_passport'
    text = pay_methods_utterances.pay_cash_passport


class PayMethodsCashChangeAmount(FinalIntent):
    name = 'pay_cash_change_amount'
    text = pay_methods_utterances.pay_cash_change_amount


class PayMethodsCashDeletedSms(FinalIntent):
    name = 'pay_cash_deleted_sms'
    text = pay_methods_utterances.pay_cash_deleted_sms


class PayMethodsYandexMoney(GeneralTopicIntent):
    name = 'pay_yandex_money'
    text = pay_methods_utterances.pay_yandex_money_options
    buttons = [pay_methods_buttons.pay_yandex_money_logins_not_match,
               pay_methods_buttons.pay_yandex_money_kz_by]


class PayMethodsYandexLoginsNotMatch(FinalIntent):
    name = 'pay_yandex_money_logins_not_match'
    text = pay_methods_utterances.pay_yandex_money_logins_not_match


class PayMethodsYandexKzBy(FinalIntent):
    name = 'pay_yandex_money_kz_by'
    text = pay_methods_utterances.pay_yandex_money_kz_by


class PayMethodsPayPal(SimpleIntent):
    name = 'pay_paypal'
    text = pay_methods_utterances.is_resident
    state_to_set = 'is_resident'


class PayMethodsPayPalResidentTrue(Confirmation, FinalIntent):
    state = 'is_resident'
    text = pay_methods_utterances.paypal_russian_resident


class PayMethodsPayPalResidentFalse(Rejection):
    state = 'is_resident'
    text = pay_methods_utterances.non_resident_options
    buttons = [pay_methods_buttons.non_resident_payment_failed,
               pay_methods_buttons.non_resident_paypal_money_withdrawn]


class PayMethodsPapPalNonResidentPaymentFailed(CallOperatorWithText):
    name = 'pay_paypal_non_resident_payment_failed'


class PayMethodsPapPalNonResidentMoneyWithdrawn(CallOperator):
    name = 'pay_paypal_non_resident_money_withdrawn'
    text = pay_methods_utterances.non_resident_paypal_money_withdrawn
