from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.consts.scenario.buttons.pay.pay_payer import pay_payer_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.pay.pay_payer import pay_payer_utterances
from crm.supskills.direct_skill.src.intents.general.call_operator_intent import CallOperator


class PayPayerGeneral(GeneralTopicIntent):
    name = 'payer_general_topic'
    text = pay_payer_utterances.payer_general_topic
    buttons = [pay_payer_buttons.payer_add,
               pay_payer_buttons.payer_edit,
               pay_payer_buttons.payer_no_address,
               pay_payer_buttons.payer_error]


class PayPayerAdd(FinalIntent):
    name = 'payer_add'
    text = pay_payer_utterances.payer_add


class PayPayerNoAddress(FinalIntent):
    name = 'payer_no_address'
    text = pay_payer_utterances.fill_address_manual


class PayPayerEdit(SimpleIntent):
    name = 'payer_edit'
    text = pay_payer_utterances.is_individual
    buttons = [pay_payer_buttons.payer_edit_individual,
               pay_payer_buttons.payer_edit_legal]


class PayPayerEditIndividual(FinalIntent):
    name = 'payer_edit_individual'
    text = pay_payer_utterances.payer_edit_individual


class PayPayerEditLegal(SimpleIntent):
    name = 'payer_edit_legal'
    text = pay_payer_utterances.payer_edit_legal_no_operator
    buttons = [pay_payer_buttons.payer_edit_legal_name,
               pay_payer_buttons.payer_edit_in_formed_docs]


class PayPayerEditWithOperatorHelp(CallOperator):
    name = 'payer_edit_legal_to_operator'
    text = pay_payer_utterances.send_data_to_edit


class PayPayerErrorGeneralTopic(GeneralTopicIntent):
    name = 'payer_error'
    text = pay_payer_utterances.payer_error_general_topic
    buttons = [pay_payer_buttons.payer_no_rrc,
               pay_payer_buttons.payer_account_error]
    state_to_set = 'payer_error'


class PayPayerNoRRC(FinalIntent):
    name = 'payer_no_rrc'
    text = pay_payer_utterances.payer_no_rrc


class PayPayerAccountError(FinalIntent):
    name = 'payer_account_error'
    text = pay_payer_utterances.payer_account_error


class PayPayerCallOperator(CallOperator):
    state = 'payer_error'
    text = pay_payer_utterances.payer_error_other
