from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent
from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.consts.scenario.buttons.pay.pay_promocode import pay_promocode_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.pay.pay_promocode import pay_promocode_utterances
from crm.supskills.direct_skill.src.intents.general.call_operator_intent import CallOperatorWithText
from crm.supskills.direct_skill.src.intents.general.confirmation_intent import Confirmation
from crm.supskills.direct_skill.src.intents.general.rejection_intent import Rejection


class PayPromocodeGeneral(GeneralTopicIntent):
    name = 'pay_promocode_general_topic'
    text = pay_promocode_utterances.pay_promocode_general_topic
    buttons = [pay_promocode_buttons.pay_promocode_howto_get,
               pay_promocode_buttons.pay_promocode_annulled,
               pay_promocode_buttons.pay_promocode_already_have,
               pay_promocode_buttons.pay_promocode_no_input,
               pay_promocode_buttons.pay_promocode_did_not_receive]


class PayPromocodeHowToGet(FinalIntent):
    name = 'pay_promocode_howto_get'
    text = pay_promocode_utterances.pay_promocode_howto_get


class PayPromocodeAnnulled(FinalIntent):
    name = 'pay_promocode_annulled'
    text = pay_promocode_utterances.pay_promocode_annulled


class PayPromocodeTerms(SimpleIntent):
    name = 'pay_promocode_already_have'
    text = pay_promocode_utterances.pay_promocode_how_to_activate
    buttons = [pay_promocode_buttons.pay_promocode_terms_conditions,
               pay_promocode_buttons.pay_promocode_expiry]


class PayPromocodeHowtoActivate(FinalIntent):
    name = 'pay_promocode_how_to_activate'
    text = pay_promocode_utterances.pay_promocode_how_to_activate


class PayPromocodeTermsConditions(FinalIntent):
    name = 'pay_promocode_terms_conditions'
    text = pay_promocode_utterances.pay_promocode_terms_conditions


class PayPromocodeExpiry(FinalIntent):
    name = 'pay_promocode_expiry'
    text = pay_promocode_utterances.pay_promocode_expiry


class PayPromocodeNoInput(FinalIntent):
    name = 'pay_promocode_no_input'
    text = pay_promocode_utterances.pay_promocode_no_input


class PayPromocodeDidNotReceive(SimpleIntent):
    name = 'pay_promocode_did_not_receive'
    text = pay_promocode_utterances.pay_promocode_did_not_receive
    buttons = [pay_promocode_buttons.pay_promocode_did_not_receive_partner,
               pay_promocode_buttons.pay_promocode_receive_partner_but_no_yandex,
               pay_promocode_buttons.pay_promocode_did_not_receive_yandex,
               pay_promocode_buttons.pay_promocode_rejected]


class PayPromocodeNotReceivedPartner(FinalIntent):
    name = 'pay_promocode_did_not_receive_partner'
    text = pay_promocode_utterances.pay_promocode_did_not_receive_partner


class PayPromocodeNotReceivedRejected(FinalIntent):
    name = 'pay_promocode_rejected'
    text = pay_promocode_utterances.pay_promocode_rejected


class PayPromocodeNotReceivedYandex(SimpleIntent):
    name = 'pay_promocode_did_not_receive_yandex'
    text = pay_promocode_utterances.if_three_days_passed
    state_to_set = 'promocode_not_received_if_three_days_passed'


class PayPromocodeNotReceivedYandexMoreThanThreeDays(Confirmation, CallOperatorWithText):
    state = 'promocode_not_received_if_three_days_passed'


class PayPromocodeNotReceivedYandexLessThanThreeDays(Rejection, FinalIntent):
    state = 'promocode_not_received_if_three_days_passed'
    text = pay_promocode_utterances.pay_promocode_deadlines
