from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.consts.scenario.buttons.pay.pay_reimburse import pay_reimburse_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.pay.pay_reimburse import pay_reimburse_utterances


class PayReimburseGeneral(GeneralTopicIntent):
    name = 'reimburse_general_topic'
    text = pay_reimburse_utterances.reimburse_general_topic
    buttons = [pay_reimburse_buttons.reimburse_login_blocked,
               pay_reimburse_buttons.reimburse_no_need,
               pay_reimburse_buttons.reimburse_vat,
               pay_reimburse_buttons.reimburse_bonus,
               pay_reimburse_buttons.reimburse_with_another_method,
               pay_reimburse_buttons.reimburse_two_side_contract,
               pay_reimburse_buttons.reimburse_deadlines]


class PayReimburseLoginBlocked(FinalIntent):
    name = 'reimburse_login_blocked'
    text = pay_reimburse_utterances.reimburse_login_blocked


class PayReimburseDeadlines(FinalIntent):
    name = 'reimburse_deadlines'
    text = pay_reimburse_utterances.reimburse_deadlines


class PayReimburseVat(FinalIntent):
    name = 'reimburse_vat'
    text = pay_reimburse_utterances.reimburse_vat


class PayReimburseBonus(FinalIntent):
    name = 'reimburse_bonus'
    text = pay_reimburse_utterances.reimburse_bonus


class PayReimburseWithAnotherMethod(FinalIntent):
    name = 'reimburse_with_another_method'
    text = pay_reimburse_utterances.reimburse_with_another_method


class PayReimburseTwoSideAgreement(FinalIntent):
    name = 'reimburse_two_side_contract'
    text = pay_reimburse_utterances.reimburse_two_side_contract
