from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.core.models.general_topic_intent import GeneralTopicIntent
from crm.supskills.direct_skill.src.consts.scenario.buttons.show_conditions.autotargeting import autotargeting_buttons
from crm.supskills.direct_skill.src.consts.scenario.utterances.show_conditions.autotargeting import autotargeting_utterances


class AutotargetingGeneral(GeneralTopicIntent):
    name = 'autotargeting_general_topic'
    text = autotargeting_utterances.autotargeting_general_topic
    buttons = [autotargeting_buttons.autotargeting_turnon,
               autotargeting_buttons.autotargeting_turnoff,
               autotargeting_buttons.autotargeting_set,
               autotargeting_buttons.autotargeting_nets,
               autotargeting_buttons.autotargeting_search,
               autotargeting_buttons.autotargeting_bets,
               autotargeting_buttons.autotargeting_statistics,
               autotargeting_buttons.autotargeting_no_shows]


class AutotargetingTurnOn(FinalIntent):
    name = 'autotargeting_turnon'
    text = autotargeting_utterances.autotargeting_turnon


class AutotargetingTurnOff(FinalIntent):
    name = 'autotargeting_turnoff'
    text = autotargeting_utterances.autotargeting_turnoff


class AutotargetingSet(FinalIntent):
    name = 'autotargeting_set'
    text = autotargeting_utterances.autotargeting_set


class AutotargetingNets(FinalIntent):
    name = 'autotargeting_nets'
    text = autotargeting_utterances.autotargeting_nets


class AutotargetingSearch(FinalIntent):
    name = 'autotargeting_search'
    text = autotargeting_utterances.autotargeting_search


class AutotargetingBets(FinalIntent):
    name = 'autotargeting_bets'
    text = autotargeting_utterances.autotargeting_bets


class AutotargetingStatistics(FinalIntent):
    name = 'autotargeting_statistics'
    text = autotargeting_utterances.autotargeting_statistics


class AutotargetingNoShows(FinalIntent):
    name = 'autotargeting_no_shows'
    text = autotargeting_utterances.autotargeting_no_shows
