from datetime import datetime

from crm.supskills.common.direct_client.structs.enums.campaigns import TextCampaignSearchStrategyTypeEnum, \
    DynamicTextCampaignSearchStrategyTypeEnum, SmartCampaignSearchStrategyTypeEnum, CampaignTypeGetEnum, \
    MobileAppCampaignSearchStrategyTypeEnum, CpmBannerCampaignSearchStrategyTypeEnum
from crm.supskills.common.direct_client.structs.enums.general import StatusEnum
from crm.supskills.common.direct_client.structs.structs.ad_groups import ServingStatusEnum
from crm.supskills.common.direct_client.structs.structs.campaigns import CampaignStateGetEnum
from crm.supskills.direct_skill.src.consts.scenario.utterances.campaign.campaign import campaign_utterances
from crm.supskills.direct_skill.src.consts.scenario.utterances.show_conditions.show_absent import show_absent_utterances
from crm.supskills.direct_skill.src.core.models.final_intent import FinalIntent
from crm.supskills.direct_skill.src.intents.general.call_operator_intent import CallOperatorWithText
from crm.supskills.direct_skill.src.intents.general.confirmation_intent import Confirmation
from crm.supskills.direct_skill.src.intents.general.rejection_intent import Rejection
from crm.supskills.direct_skill.src.intents.general.simple_direct_intent import SimpleDirectIntent
from pytz import timezone

from crm.supskills.direct_skill.src.core.models.simple_intent import SimpleIntent


def get_local_time(time_zone) -> datetime:
    return timezone(time_zone).fromutc(datetime.utcnow())


def to_moscow_time(time: datetime) -> datetime:
    return timezone('Europe/Moscow').localize(time)


def is_now_work_hour(campaign) -> bool:
    week_schedule = {int(s[0]): s[2:] for s in campaign.TimeTargeting.Schedule.Items}
    if get_local_time(campaign.TimeZone).weekday() + 1 in week_schedule.keys():
        today_schedule = list(map(int, week_schedule[get_local_time(campaign.TimeZone).weekday() + 1].split(',')))
    else:
        today_schedule = [100]*24
    return today_schedule[get_local_time(campaign.TimeZone).hour] != 0


def is_campaign_started(campaign):
    start_time = to_moscow_time(datetime.strptime(campaign.StartDate, "%Y-%m-%d"))
    current_time = get_local_time(campaign.TimeZone)
    return start_time < current_time


def is_strategy_with_search(campaign) -> bool:
    return not (
        campaign.Type == CampaignTypeGetEnum.TEXT_CAMPAIGN and
        campaign.TextCampaign.BiddingStrategy.Search.BiddingStrategyType == TextCampaignSearchStrategyTypeEnum.SERVING_OFF
        or
        campaign.Type == CampaignTypeGetEnum.SMART_CAMPAIGN and
        campaign.SmartCampaign.BiddingStrategy.Search.BiddingStrategyType == SmartCampaignSearchStrategyTypeEnum.SERVING_OFF
        or
        campaign.Type == CampaignTypeGetEnum.DYNAMIC_TEXT_CAMPAIGN and
        campaign.DynamicTextCampaign.BiddingStrategy.Search.BiddingStrategyType == DynamicTextCampaignSearchStrategyTypeEnum.SERVING_OFF
        or
        campaign.Type == CampaignTypeGetEnum.MOBILE_APP_CAMPAIGN and
        campaign.MobileAppCampaign.BiddingStrategy.Search.BiddingStrategyType == MobileAppCampaignSearchStrategyTypeEnum.SERVING_OFF
        or
        campaign.Type == CampaignTypeGetEnum.CPM_BANNER_CAMPAIGN and
        campaign.CpmBannerCampaign.BiddingStrategy.Search.BiddingStrategyType == CpmBannerCampaignSearchStrategyTypeEnum.SERVING_OFF)  # noqa: E221


def is_there_one_campaign(campaigns, groups, ads):
    return len(campaigns) == 1 or len(groups) + len(ads) == 1 or \
        len(groups) == len(ads) == 1 and groups[0].CampaignId == ads[0].CampaignId


class ShowAbsentGeneral(SimpleDirectIntent):
    name = 'show_absent'
    text = campaign_utterances.asking_campaign_number
    state = ''
    state_to_set = 'campaign_number_requested_show_absent'

    async def select_direct_intent(self, conversation, direct5, direct4, login, campaigns, groups, ads):
        if is_there_one_campaign(campaigns, groups, ads):
            return await ShowAbsentGeneralCheck.select_direct_intent(self, conversation, direct5, direct4, login, campaigns, groups, ads)
        return 'show_absent', ''


class ShowAbsentGeneralCheck(SimpleDirectIntent):
    state = 'campaign_number_requested_show_absent'

    async def select_direct_intent(self, conversation, direct5, direct4, login, campaigns, groups, ads):
        if is_there_one_campaign(campaigns, groups, ads):
            if len(campaigns):
                campaign = campaigns[0]
            else:
                if len(groups) == len(ads) == 1 and groups[0].CampaignId == ads[0].CampaignId:
                    campaign_id = groups[0].CampaignId
                elif len(groups) == 1 and len(ads) == 0:
                    campaign_id = groups[0].CampaignId
                else:
                    campaign_id = ads[0].CampaignId
                campaign = await direct5.get_campaign(login, campaign_id)
            if campaign.State == CampaignStateGetEnum.ARCHIVED or campaign.State == CampaignStateGetEnum.CONVERTED:
                return 'show_absent_campaign_archived_or_converted', ''
            if campaign.State == CampaignStateGetEnum.SUSPENDED:
                return 'show_absent_campaign_suspended', ''
            if campaign.State == CampaignStateGetEnum.ENDED:
                return 'show_absent_campaign_ended', ''
            if campaign.State == CampaignStateGetEnum.OFF:
                if campaign.Status == StatusEnum.MODERATION:
                    return 'show_absent_campaign_off_moderation', ''
                if campaign.Status == StatusEnum.DRAFT:
                    return 'show_absent_campaign_off_draft', ''
                if campaign.Status == StatusEnum.REJECTED:
                    return 'show_absent_campaign_off_rejected', ''
            if not is_campaign_started(campaign):
                return 'show_absent_start_date_later_than_now', ''
            if not is_now_work_hour(campaign):
                return 'show_absent_time_targeting', ''
            ad_groups = await direct5.get_ad_groups(login, campaign.Id)
            if all([ad_group.ServingStatus == ServingStatusEnum.RARELY_SERVED for ad_group in ad_groups]):
                return 'show_absent_ads_rarely_served', ''
            if is_strategy_with_search(campaign):
                return 'show_absent_check_shows_algorithm', 'if_found_on_search'
            else:
                return 'YANDEX_REJECT', 'if_found_on_search'
        return 'call_operator', ''


class ShowAbsentCheckShowAlgorithm(SimpleIntent):
    name = 'show_absent_check_shows_algorithm'
    text = show_absent_utterances.check_shows_algorithm
    state_to_set = 'if_found_on_search'


class ShowAbsentSuspended(FinalIntent):
    name = 'show_absent_campaign_suspended'
    text = show_absent_utterances.campaign_suspended


class ShowAbsentArchived(FinalIntent):
    name = 'show_absent_campaign_archived_or_converted'
    text = show_absent_utterances.campaign_archived_or_converted


class ShowAbsentEnded(FinalIntent):
    name = 'show_absent_campaign_ended'
    text = show_absent_utterances.campaign_ended


class ShowAbsentModeration(FinalIntent):
    name = 'show_absent_campaign_off_moderation'
    text = show_absent_utterances.campaign_off_moderation


class ShowAbsentDraft(FinalIntent):
    name = 'show_absent_campaign_off_draft'
    text = show_absent_utterances.campaign_off_draft


class ShowAbsentRejected(FinalIntent):
    name = 'show_absent_campaign_off_rejected'
    text = show_absent_utterances.campaign_off_rejected


class ShowAbsentRarelyServed(FinalIntent):
    name = 'show_absent_ads_rarely_served'
    text = show_absent_utterances.ads_rarely_served


class ShowAbsentTimeTargeting(FinalIntent):
    name = 'show_absent_time_targeting'
    text = show_absent_utterances.time_targeting


class ShowAbsentStartDateLaterThanNow(FinalIntent):
    name = 'show_absent_start_date_later_than_now'
    text = show_absent_utterances.start_date_later_than_now


class ShowAbsentFoundOnSearchYes(FinalIntent, Confirmation):
    state = 'if_found_on_search'
    text = show_absent_utterances.client_found_ad


class ShowAbsentFoundOnSearchNo(Rejection):
    state = 'if_found_on_search'
    text = show_absent_utterances.if_weekly_daily_budget
    state_to_set = 'if_weekly_daily_budget'


class ShowAbsentBudgetYes(FinalIntent, Confirmation):
    state = 'if_weekly_daily_budget'
    text = show_absent_utterances.weekly_daily_budget


class ShowAbsentBudgetNo(Rejection):
    state = 'if_weekly_daily_budget'
    text = show_absent_utterances.if_money_on_account
    state_to_set = 'if_money_on_account'


class ShowAbsentMoneyOnAccountNo(FinalIntent, Rejection):
    state = 'if_money_on_account'
    text = show_absent_utterances.no_money_on_account


class ShowAbsentMoneyOnAccountYes(Confirmation):
    state = 'if_money_on_account'
    text = show_absent_utterances.if_changes_happened
    state_to_set = 'if_changes_happened'


class ShowAbsentChangesYes(FinalIntent, Confirmation):
    state = 'if_changes_happened'
    text = show_absent_utterances.changes_happened


class ShowAbsentChangesNo(CallOperatorWithText):
    name = 'YANDEX_REJECT'
    state = 'if_changes_happened'
