import requests
import re
from datetime import datetime
from ci.tasklet.common.proto import service_pb2 as ci
from tasklet.services.yav.proto import yav_pb2 as yav
from crm.supskills.tasklets.changelog.proto import changelog_tasklet


class ChangelogImpl(changelog_tasklet.ChangelogBase):

    def run(self):
        spec = yav.YavSecretSpec(uuid=self.input.context.secret_uid, key='wiki.token')
        wiki_oauth_token = self.ctx.yav.get_secret(spec).secret

        request = ci.GetCommitsRequest()
        request.flow_launch_id = self.input.context.job_instance_id.flow_launch_id
        request.limit = 500  # Can NOT be more 1000? but in wonderful world it's INF
        response = self.ctx.ci.GetCommits(request)
        if response.HasField('next'):
            raise OverflowError(f'Error: Too mach commits: more than {request.limit} commits!')

        changelog = self.format_commits(response.commits)
        data = {'version': '113005495', 'changes': [
            {'added_row':  {'after_id': '-1', 'data': {'100': str(datetime.now().date()), '102': changelog}}}]}
        headers = {'Authorization': f'OAuth {wiki_oauth_token}'}
        self.output.result.message = str(requests.post(self.input.config.wiki_page, headers=headers, json=data))

    def format_commits(self, commits) -> str:
        return ' \n'.join([self.format_commit(commit) for commit in commits])

    @staticmethod
    def format_commit(commit) -> str:
        commit_message = str(commit.message) or 'No info!'
        if "Merge from '" in commit_message:
            match = re.search(r"[A-Z]+-\d+", commit_message)
            commit_message = match.group()
        return commit_message
