# Woof MD

## Install

```sh
npm install @yandex-int/remark-woofmd
```

## Usage

```js
const remark = require('remark');
const { vis, remark: remarkWoofmd } = require('remark-woofmd');
const processor = remark().data('settings', { commonmark: true, footnotes: true }).use(remarkWoofmd);
const go = s => vis(processor.parse(s));

go(`
# Best addon for your pluphone

Perfecto is real! Right, staff:johnston

Text Before formatter block.
%%(prettify align=center)
Text inside
formatter with //emphasis// and **bold**.
%%
Text just after the formatter block.

<{ Big quote block here

## With headings

}>


<{ Cut string **Bold here** and !!(green) Apple text !! too.
    🍏🍎🍏🍎🍏🍎🍏🍏🍏🍏🍏🍒🍏🍒🍏🍒.

    Yep.
}>

##+Rolled section

This part is hidden for the first look

## Usual heading

Hey boys, it's the end!
`);
```

## API

### `processor().use(remarkWoofmd[, options])`

##### `options`

###### `options.actions`

An array of actions that will be parsed as `womAction`. (Action[])

```js
interface Action {
    name: string;
}
```

###### `options.tracker`

An description of tracker that will be parsed as `womTicket`. (Tracker)

```ts
interface Tracker {
    url: string,
    aliases: string[],
}
```
