// https://st.yandex-team.ru/WIKI-13934

const { decode: htmlEntitiesDecode } = require('../utils/html-entities');

function normalize(ctx, position) {
    let offsets = ctx.offset;
    let line = position.line;
    let result = [];

    while (++line) {
        if (!(line in offsets)) {
            break;
        }

        result.push((offsets[line] || 0) + 1);
    }

    return { start: position, indent: result };
}

function patch(Parser) {
    function MonkeyPatchedParser() {
        Parser.apply(this, arguments);

        const ctx = this;

        function decode(value, position, handler) {
            handler(htmlEntitiesDecode(value), normalize(ctx, position), value);
        }

        decode.raw = htmlEntitiesDecode;

        this.decode = decode;
    }

    MonkeyPatchedParser.prototype = Parser.prototype;

    return MonkeyPatchedParser;
}

exports.patch = patch;
